/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.fsutils;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.common.jobs.xmlbeans.IngestSettingsDocument;
import com.exlibris.digitool.exceptions.IngestException;
import com.exlibris.digitool.file_descriptor.xmlbeans.FdsDocument;
import com.exlibris.digitool.fsutils.FSIngestUtil;
import com.exlibris.digitool.fsutils.FSTransformUtil;
import com.exlibris.digitool.shared.dataObjects.IngestStatusEnum;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.apache.xmlbeans.XmlException;

public class FSLoadUtil {
    private static final String INGEST_SETTINGS_FILE = "ingest_settings.xml";
    public static final String FDS_FILE = "fds.xml";
    private static final String JOBS_LOG_FILE = "jobs.log";
    private static final String TASKER_STATUS_FILE = "tasker_status.log";
    private static final String LAST_STATUS_FILE = "last_status.log";
    private static final String RUNNING_STATUS_FILE = ".running";
    private static final String ERROR_COMPLETED_STATUS_FILE = ".error_completed";
    private static final String SUCCESS_COMPLETED_STATUS_FILE = ".success_completed";
    private static final int RUNNING_STATUS = 100;
    private static final int ERROR_COMPLETED_STATUS = 200;
    private static final int SUCCESS_COMPLETED_STATUS = 300;
    private static final String DEPOSIT_PREFIX = "dep";
    private GregorianCalendar m_calendar = new GregorianCalendar();
    private StringBuffer m_buffer = null;
    private String m_folderId = null;
    private String m_folderDir = null;
    private FSIngestUtil m_ingestUtil = null;
    private FSTransformUtil m_transformUtil = null;
    private Hashtable m_fosHash = new Hashtable();
    private BufferedReader portionReader;

    protected FSLoadUtil(String folderDir, String folderId) {
        this.m_folderId = folderId;
        this.m_buffer = new StringBuffer(100);
        this.m_folderDir = this.m_buffer.append(folderDir).append(this.getFolderPrefix()).append(this.m_folderId).append(FSUtil.SEPARATOR).toString();
        this.m_ingestUtil = new FSIngestUtil(this.m_folderDir, "");
        this.m_transformUtil = new FSTransformUtil(this.m_folderDir, "");
    }

    String getFolderPrefix() {
        return "load_";
    }

    public boolean isExists() {
        File f = new File(this.m_folderDir);
        return f.exists();
    }

    public String getFolderDir() {
        return this.m_folderDir;
    }

    public boolean createNewDirStructure() {
        FileUtil.createFile(this.m_folderDir);
        this.m_ingestUtil.createNewDirStructure();
        this.m_transformUtil.createNewDirStructure();
        try {
            this.createIngestSettings();
            this.createJobsLog();
        }
        catch (IngestException ie) {
            return false;
        }
        return true;
    }

    public FSIngestUtil getFSIngestUtil() {
        return this.m_ingestUtil;
    }

    public FSTransformUtil getFSTransformUtil() {
        return this.m_transformUtil;
    }

    public IngestSettingsDocument getIngestSetting() throws XmlException, IOException {
        return IngestSettingsDocument.Factory.parse(new File(this.m_folderDir + INGEST_SETTINGS_FILE));
    }

    public boolean saveIngestSetting(IngestSettingsDocument isd) throws XmlException, IOException {
        try {
            isd.save(new File(this.m_folderDir + INGEST_SETTINGS_FILE));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveFDS(FdsDocument fsd) throws XmlException, IOException {
        try {
            fsd.save(new File(this.m_folderDir + FDS_FILE));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFile(String relativePath, String fileName, InputStream doc) throws IOException {
        if (this.m_folderDir == null) {
            return false;
        }
        File nFile = new File(this.m_folderDir + relativePath);
        if (!nFile.exists()) {
            nFile.mkdirs();
        }
        try (BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(nFile.getAbsolutePath() + "/" + fileName));){
            IOUtil.copy(doc, (OutputStream)bof);
        }
        return true;
    }

    public void writeStatus(String msg) {
        this.writeMsgInternal(msg, TASKER_STATUS_FILE, true, false, false);
        this.writeMsgInternal(msg, LAST_STATUS_FILE, false, true, false);
    }

    public void writeMsg(String msg) {
        this.writeMsgInternal(msg, JOBS_LOG_FILE, true, false, true);
    }

    public void writeMsgInternal(String msg, String fileName, boolean append, boolean closeFile, boolean writeToConsole) {
        BufferedOutputStream fos = (BufferedOutputStream)this.m_fosHash.get(fileName);
        if (fos == null) {
            try {
                fos = new BufferedOutputStream(new FileOutputStream(this.m_folderDir + fileName, append));
            }
            catch (Exception e) {
                System.out.println("Fail to init log file:" + this.m_folderDir + fileName);
            }
        }
        try {
            StringBuffer fullMsg = new StringBuffer(DateHandler.formatDateAndTime(new Date())).append(" : ").append(msg).append("\n");
            IOUtil.copy(fullMsg.toString(), (OutputStream)fos);
            if (writeToConsole) {
                System.out.print(fullMsg);
            }
            if (!closeFile) {
                this.m_fosHash.put(fileName, fos);
            } else {
                fos.close();
            }
        }
        catch (IOException e1) {
            System.out.println("Fail writing message to log:" + msg);
        }
    }

    public void close() {
        Enumeration enums = this.m_fosHash.elements();
        while (enums.hasMoreElements()) {
            BufferedOutputStream fos = (BufferedOutputStream)enums.nextElement();
            if (fos == null) continue;
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getJobsLogContents() throws IOException {
        File f = new File(this.m_folderDir + JOBS_LOG_FILE);
        if (!f.exists()) {
            return "";
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringWriter sw = new StringWriter();
        IOUtil.copy((Reader)br, (Writer)sw);
        return sw.toString();
    }

    public synchronized String getNextJobsLogContentsPortion() throws IOException {
        if (this.portionReader == null) {
            File f = new File(this.m_folderDir + JOBS_LOG_FILE);
            this.portionReader = new BufferedReader(new FileReader(f));
        }
        StringWriter sw = new StringWriter();
        IOUtil.copy((Reader)this.portionReader, (Writer)sw);
        return sw.toString();
    }

    public void initPortionReader(int charsToSkip) throws IOException {
        File f = new File(this.m_folderDir + JOBS_LOG_FILE);
        this.portionReader = new BufferedReader(new FileReader(f));
        this.portionReader.skip(charsToSkip);
    }

    public String getTaskStatusContents() throws IOException {
        File f = new File(this.m_folderDir + TASKER_STATUS_FILE);
        if (!f.exists()) {
            return "";
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringWriter sw = new StringWriter();
        IOUtil.copy((Reader)br, (Writer)sw);
        return sw.toString();
    }

    public String readProcessingMessage() {
        String status;
        try {
            FileReader fr = new FileReader(this.m_folderDir + LAST_STATUS_FILE);
            BufferedReader br = new BufferedReader(fr);
            status = br.readLine();
        }
        catch (Exception e) {
            return null;
        }
        return status;
    }

    public void setRunningStatus() {
        this.deleteStatusFiles();
        File f = new File(this.m_folderDir + RUNNING_STATUS_FILE);
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setErrorCompletedStatus() {
        this.deleteStatusFiles();
        File f = new File(this.m_folderDir + ERROR_COMPLETED_STATUS_FILE);
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSuccessCompletedStatus() {
        this.deleteStatusFiles();
        File f = new File(this.m_folderDir + SUCCESS_COMPLETED_STATUS_FILE);
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IngestStatusEnum getStatus() {
        File f = new File(this.m_folderDir + RUNNING_STATUS_FILE);
        if (f.exists()) {
            return IngestStatusEnum.RUNNING;
        }
        f = new File(this.m_folderDir + ERROR_COMPLETED_STATUS_FILE);
        if (f.exists()) {
            return IngestStatusEnum.ERROR_COMPLETED;
        }
        f = new File(this.m_folderDir + SUCCESS_COMPLETED_STATUS_FILE);
        if (f.exists()) {
            return IngestStatusEnum.SUCCESS_COMPLETED;
        }
        return null;
    }

    private void deleteStatusFiles() {
        File f = new File(this.m_folderDir + RUNNING_STATUS_FILE);
        f.delete();
        f = new File(this.m_folderDir + ERROR_COMPLETED_STATUS_FILE);
        f.delete();
        f = new File(this.m_folderDir + SUCCESS_COMPLETED_STATUS_FILE);
        f.delete();
    }

    public void rollbackLoad() {
        File lastStatusFile;
        File taskerStatusFile;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String dateStr = simpleDateFormat.format(new Date());
        this.deleteStatusFiles();
        File jobsLogFile = new File(FSUtil.appendPath(this.m_folderDir, JOBS_LOG_FILE));
        if (jobsLogFile.exists()) {
            String rollbackJobsLogFileName = FSUtil.appendPath(this.m_folderDir, JOBS_LOG_FILE) + "." + dateStr;
            jobsLogFile.renameTo(new File(rollbackJobsLogFileName));
        }
        if ((taskerStatusFile = new File(FSUtil.appendPath(this.m_folderDir, TASKER_STATUS_FILE))).exists()) {
            String rollbackTaskerStatusFileName = FSUtil.appendPath(this.m_folderDir, TASKER_STATUS_FILE) + "." + dateStr;
            taskerStatusFile.renameTo(new File(rollbackTaskerStatusFileName));
        }
        if ((lastStatusFile = new File(FSUtil.appendPath(this.m_folderDir, LAST_STATUS_FILE))).exists()) {
            String rollbackLastStatusFileName = FSUtil.appendPath(this.m_folderDir, LAST_STATUS_FILE) + "." + dateStr;
            lastStatusFile.renameTo(new File(rollbackLastStatusFileName));
        }
    }

    private void createIngestSettings() throws IngestException {
        try {
            IngestSettingsDocument iDoc = IngestSettingsDocument.Factory.newInstance();
            iDoc.addNewIngestSettings();
            iDoc.save(new File(this.m_folderDir + INGEST_SETTINGS_FILE));
        }
        catch (IOException ioe) {
            throw new IngestException(DescriptorConstants.IG_CantCreateIngestSettingDoc, (Object)ioe.getMessage(), FSLoadUtil.class);
        }
    }

    private void createJobsLog() throws IngestException {
        try {
            new File(this.m_folderDir + JOBS_LOG_FILE).createNewFile();
        }
        catch (IOException io) {
            throw new IngestException(DescriptorConstants.IG_CantCreateIngestJobsLog, (Object)this.m_folderId, io.getMessage());
        }
    }

    public void deleteJobsLogContent() throws IngestException {
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.m_folderDir + JOBS_LOG_FILE, false));
            fos = new BufferedOutputStream(new FileOutputStream(this.m_folderDir + TASKER_STATUS_FILE, false));
        }
        catch (FileNotFoundException fnf) {
            throw new IngestException(DescriptorConstants.IG_CantCreateIngestJobsLog, (Object)this.m_folderId, fnf.getMessage());
        }
    }

    public void deleteDirStructure() throws IOException {
        FileUtil.forceDelete(this.m_folderDir);
    }

    public String getFolderId() {
        return this.m_folderId;
    }

    public boolean isFromDeposit() {
        return this.m_folderId.startsWith(DEPOSIT_PREFIX);
    }
}

