/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.security;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class CustomerInstitutionRetriever {
    private static final Logger logger = Logger.getLogger(CustomerInstitutionRetriever.class);
    public static final String CONTEXT_MD_EDITOR = "CONTEXT_MD_EDITOR";
    public static final ThreadLocal<Boolean> allowOnlineSilentLogin = new ThreadLocal();
    private static final ThreadLocal<String> onlineContext = new ThreadLocal();
    public static final ThreadLocal<Long> customerIdLocalThread = new ThreadLocal();
    public static final ThreadLocal<Long> institutionIdLocalThread = new ThreadLocal();
    public static final ThreadLocal<Principal> userPrincipalLocalThread = new ThreadLocal();
    public static final ThreadLocal<HttpServletRequest> httpServletRequestLocalThread = new ThreadLocal();

    public static void clear() {
        customerIdLocalThread.remove();
        institutionIdLocalThread.remove();
        userPrincipalLocalThread.remove();
        httpServletRequestLocalThread.remove();
        allowOnlineSilentLogin.remove();
        onlineContext.remove();
        MDC.remove((String)"inst");
    }

    public static void setInstitutionCustomerId(Long customerId, Long institutionId) {
        customerIdLocalThread.set(customerId);
        institutionIdLocalThread.set(institutionId);
    }

    public static Long getCustomerId() {
        return customerIdLocalThread.get();
    }

    public static Long getInstitutionId() {
        return institutionIdLocalThread.get();
    }

    public static void setServletRequest(HttpServletRequest request) {
        httpServletRequestLocalThread.set(request);
    }

    public static HttpServletRequest getServletRequest() {
        return httpServletRequestLocalThread.get();
    }

    public static void setPrincipal(Principal principal) {
        userPrincipalLocalThread.set(principal);
    }

    public static Principal getPrincipal() {
        return userPrincipalLocalThread.get();
    }

    public static Boolean isAllowedOnlineSilentLogin() {
        return BooleanUtils.isTrue((Boolean)allowOnlineSilentLogin.get());
    }

    public static void disableAllowedOnlineSilentLogin() {
        CustomerInstitutionRetriever.setAllowedOnlineSilentLogin(false);
    }

    public static void enableAllowedOnlineSilentLogin() {
        CustomerInstitutionRetriever.setAllowedOnlineSilentLogin(true);
    }

    private static void setAllowedOnlineSilentLogin(Boolean securityCheck) {
        allowOnlineSilentLogin.set(securityCheck);
    }

    public static String getOnlinecontext() {
        return onlineContext.get();
    }

    public static void setOnlinecontext(String context) {
        onlineContext.set(context);
    }

    public static void clearOnlineContext() {
        onlineContext.remove();
    }
}

