/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.plugins;

import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.plugins.HFrPluginInstance;
import com.exlibris.core.infra.model.plugins.MaterialType;
import com.exlibris.core.infra.model.plugins.PluginGeneralType;
import java.util.Collection;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;

@Entity
@AttributeOverride(name="id", column=@Column(name="PLUGIN_TYPE_ID"))
@Table(name="HFRPLUGIN_TYPE", uniqueConstraints={@UniqueConstraint(columnNames={"plugin_type_name"})})
public class HFrPluginType
extends HOwneredEntity {
    private static final long serialVersionUID = 1L;
    private String pluginTypeName;
    private String pluginTypeDescription;
    private String pluginInterface;
    private String scriptRunnerClass;
    private Long pluginParentId;
    private MaterialType materialType;
    private String resourceType;
    private String module;
    private PluginGeneralType generalType;
    private String deletionClass;
    private Boolean allowedPublicAPI;
    public String generalParms;
    private String pluginListener;
    private String indexXml;
    private Collection<HFrPluginInstance> instanceList;

    public HFrPluginType() {
        this.materialType = MaterialType.DIGITAL;
        this.generalType = PluginGeneralType.TASK;
    }

    public HFrPluginType(HFrPluginType type) {
        this.pluginTypeName = type.getPluginTypeName();
        this.pluginTypeDescription = type.getPluginTypeDescription();
        this.pluginInterface = type.getPluginInterface();
        this.scriptRunnerClass = type.getScriptRunnerClass();
        this.pluginParentId = type.getPluginParentId();
        this.materialType = type.getMaterialType();
        this.resourceType = type.getResourceType();
        this.module = type.getModule();
        this.generalType = type.getGeneralType();
        this.deletionClass = type.getDeletionClass();
        this.allowedPublicAPI = type.getAllowedPublicAPI();
        this.generalParms = type.generalParms;
        super.setOwner(type.getOwner());
    }

    @OneToMany(mappedBy="pluginType", targetEntity=HFrPluginInstance.class, fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Collection<HFrPluginInstance> getInstanceList() {
        return this.instanceList;
    }

    public void setInstanceList(List<HFrPluginInstance> instanceList) {
        this.instanceList = instanceList;
    }

    @Column(length=50, name="material_type", nullable=false)
    @Searchable
    @Enumerated(value=EnumType.ORDINAL)
    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(MaterialType materialName) {
        this.materialType = materialName;
    }

    @Column(length=255, name="plugin_type_name")
    @Searchable
    public String getPluginTypeName() {
        return this.pluginTypeName;
    }

    public void setPluginTypeName(String pluginName) {
        this.pluginTypeName = pluginName;
    }

    @Column(length=2000, name="plugin_type_description")
    public String getPluginTypeDescription() {
        return this.pluginTypeDescription;
    }

    public void setPluginTypeDescription(String pluginDescription) {
        this.pluginTypeDescription = pluginDescription;
    }

    @Column(length=255, name="plugin_interface", nullable=false)
    @Searchable
    public String getPluginInterface() {
        return this.pluginInterface;
    }

    public void setPluginInterface(String pluginInterface) {
        this.pluginInterface = pluginInterface;
    }

    @Column(length=255, name="script_runner_class")
    @Searchable
    public String getScriptRunnerClass() {
        return this.scriptRunnerClass;
    }

    public void setScriptRunnerClass(String scriptRunnerClass) {
        this.scriptRunnerClass = scriptRunnerClass;
    }

    @Column(name="plugin_type_parent_id")
    @Searchable
    public Long getPluginParentId() {
        return this.pluginParentId;
    }

    public void setPluginParentId(Long pluginParentId) {
        this.pluginParentId = pluginParentId;
    }

    @Column(length=255, name="resource_type")
    @Searchable
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String pluginResourceType) {
        this.resourceType = pluginResourceType;
    }

    @Column(length=255, name="module")
    @Searchable
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Column(length=50, name="general_type", nullable=false)
    @Searchable
    @Enumerated(value=EnumType.ORDINAL)
    public PluginGeneralType getGeneralType() {
        return this.generalType;
    }

    public void setGeneralType(PluginGeneralType pluginGeneralType) {
        this.generalType = pluginGeneralType;
    }

    @Column(length=255, name="deletion_class")
    @Searchable
    public String getDeletionClass() {
        return this.deletionClass;
    }

    public void setDeletionClass(String pluginDeletionClass) {
        this.deletionClass = pluginDeletionClass;
    }

    @Column(name="allowed_public_api")
    @Searchable
    public Boolean getAllowedPublicAPI() {
        return this.allowedPublicAPI;
    }

    public void setAllowedPublicAPI(Boolean pluginAllowedPublicAPI) {
        this.allowedPublicAPI = pluginAllowedPublicAPI;
    }

    @Column(name="general_parms")
    @Lob
    public String getGeneralParms() {
        return this.generalParms;
    }

    public void setGeneralParms(String generalParms) {
        this.generalParms = generalParms;
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Column(length=255, name="plugin_listener")
    public String getPluginListener() {
        return this.pluginListener;
    }

    public void setPluginListener(String pluginListener) {
        this.pluginListener = pluginListener;
    }
}

