/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.formatting.md;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.formatting.MarcHandler;
import com.exlibris.digitool.common.formatting.md.DescriptiveMDExtractor;
import com.exlibris.digitool.common.streams.UTF8FileInputStream;
import gov.loc.marc21.slim.CollectionDocument;
import gov.loc.marc21.slim.DataFieldType;
import gov.loc.marc21.slim.RecordType;
import gov.loc.marc21.slim.SubfieldatafieldType;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;

public class MarcMDExtractor
implements DescriptiveMDExtractor {
    private static ExLogger logger = ExLogger.getExLogger(MarcMDExtractor.class);
    public RecordType[] recordType = null;

    public MarcMDExtractor() {
    }

    public MarcMDExtractor(String fileName) throws XmlException, IOException {
        this.recordType = CollectionDocument.Factory.parse(new UTF8FileInputStream(fileName)).getCollection().getRecordArray();
    }

    @Override
    public Object[] getRecords() {
        return this.recordType;
    }

    public String extract(RecordType recordType, String tag, String code) {
        String data = "";
        if (recordType != null && tag != null && code != null && code.trim().length() != 0) {
            DataFieldType[] dataFieldType = recordType.getDatafieldArray();
            for (int i = 0; i < dataFieldType.length; ++i) {
                if (!tag.equals(dataFieldType[i].getTag())) continue;
                SubfieldatafieldType[] subfieldatafieldType = dataFieldType[i].getSubfieldArray();
                for (int j = 0; j < subfieldatafieldType.length; ++j) {
                    if (code.indexOf(subfieldatafieldType[j].getCode()) == -1 || subfieldatafieldType[j].getStringValue().equals("")) continue;
                    data = data + subfieldatafieldType[j].getStringValue();
                }
            }
        }
        return data;
    }

    @Override
    public String extractData(Object record, String key) {
        String extractedData = "";
        try {
            MarcHandler marcHandler = new MarcHandler("<?xml version=\"1.0\" encoding=\"UTF-8\" ?> " + record.toString());
            extractedData = marcHandler.getValue(key);
        }
        catch (XmlException e) {
            logger.info(DescriptorConstants.IN_FailedReplaceValueInDE);
        }
        return extractedData;
    }

    @Override
    public String extractXMLData(Object rt) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> " + ((RecordType)rt).newCursor().xmlText();
    }
}

