/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.infrastructure.oai;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.digitool.fsutils.FSLoadUtil;
import com.exlibris.digitool.infrastructure.oai.BadResumptionTokenException;
import com.exlibris.digitool.infrastructure.oai.OAIException;
import com.exlibris.digitool.infrastructure.oai.OAIRequestFailedException;
import com.exlibris.digitool.infrastructure.oai.OAIResumptionRequestFailedException;
import com.exlibris.digitool.infrastructure.oai.OAISaxParser;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class OAIHarvester {
    private String listRecordsResumptionToken;
    private String responeDate;
    private String listIdentifiersResumptionToken;
    private String listSetsResumptionToken;
    private String url;
    private boolean hasMoreRecords;
    private boolean hasMoreIdentifiers;
    private boolean hasMoreSets;
    private boolean isGet = true;
    private OAISaxParser handler;
    private SAXParser parser;
    public static String DC_PREFIX = "oai_dc:dc";
    public static String MARC_PREFIX = "marc:record";
    private static ExLogger log = ExLogger.getExLogger(OAIHarvester.class);
    private FSLoadUtil fsLoad = null;

    public OAIHarvester(String url, String parserClassName) throws OAIException {
        this.url = url;
        try {
            this.handler = (OAISaxParser)Class.forName(parserClassName).newInstance();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.parser = factory.newSAXParser();
        }
        catch (Throwable t) {
            throw new OAIException(t);
        }
    }

    protected List getRecord(String identifier, String metadataPrefix) throws OAIException {
        List list;
        InputStream is = null;
        try {
            String qstring = "verb=GetRecord&identifier=" + URLEncoder.encode(identifier, "UTF-8") + "&metadataPrefix=" + URLEncoder.encode(metadataPrefix, "UTF-8");
            this.writeToLog("Performing GetRecord method with parameters " + qstring);
            is = this.sendRequest(qstring);
            this.parser.parse(is, (DefaultHandler)this.handler);
            list = this.handler.getElementList();
        }
        catch (Throwable t) {
            try {
                throw new OAIException(t);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(is);
        return list;
    }

    protected InputStream identify() throws OAIException {
        String qstring = "verb=Identify";
        try {
            return this.sendRequest(qstring);
        }
        catch (Throwable t) {
            throw new OAIException(t);
        }
    }

    protected InputStream listIdentifiers(String metadataPrefix, Date from, Date until, String set) throws OAIException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-DD'T'hh:mm:ssZ");
        try {
            String date;
            String qstring = "verb=ListIdentifiers&metadataPrefix=" + URLEncoder.encode(metadataPrefix, "UTF-8");
            if (from != null) {
                date = dateFormat.format(from);
                qstring = qstring + "&from=" + URLEncoder.encode(date, "UTF-8");
            }
            if (until != null) {
                date = dateFormat.format(until);
                qstring = qstring + "&until=" + URLEncoder.encode(date, "UTF-8");
            }
            if (set != "" && set != null) {
                qstring = qstring + "&set=" + URLEncoder.encode(set, "UTF-8");
            }
            return this.sendRequest(qstring);
        }
        catch (Throwable t) {
            throw new OAIException(t);
        }
    }

    protected InputStream listIdentifiers() throws OAIException {
        if (this.listIdentifiersResumptionToken == null) {
            throw new BadResumptionTokenException("Resumption Token is not set. This function may only be called to retrieve additional records after the initial ListRecords request with at least one parameter have been performed ");
        }
        try {
            String qstring = "verb=ListIdentifiers&resumptionToken=" + URLEncoder.encode(this.listIdentifiersResumptionToken, "UTF-8");
            return this.sendRequest(qstring);
        }
        catch (Throwable t) {
            throw new OAIException(t);
        }
    }

    protected InputStream listMetadataFormats(String identifier) throws OAIException {
        try {
            String qstring = "verb=ListmetadataFormats";
            if (identifier != null & !identifier.equalsIgnoreCase("")) {
                qstring = qstring + "&identifier=" + URLEncoder.encode(identifier, "UTF-8");
            }
            return this.sendRequest(qstring);
        }
        catch (Throwable t) {
            throw new OAIException(t);
        }
    }

    protected List listRecords(String metadataPrefix, String from, String until, String set) throws OAIException {
        List list;
        InputStream is = null;
        try {
            String qstring = "verb=ListRecords&metadataPrefix=" + URLEncoder.encode(metadataPrefix, "UTF-8");
            if (from != null && !from.equals("")) {
                qstring = qstring + "&from=" + URLEncoder.encode(from, "UTF-8");
            }
            if (until != null && !until.equals("")) {
                qstring = qstring + "&until=" + URLEncoder.encode(until, "UTF-8");
            }
            if (set != "" && set != null) {
                qstring = qstring + "&set=" + URLEncoder.encode(set, "UTF-8");
            }
            this.writeToLog("Performing ListRecords method with parameters " + qstring);
            is = this.sendRequest(qstring);
            this.parser.parse(is, (DefaultHandler)this.handler);
            list = this.handler.getElementList();
        }
        catch (Throwable t) {
            try {
                throw new OAIException(t);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(is);
        return list;
    }

    protected String getResumptionToken() {
        return this.handler.getResumptionToken();
    }

    public String getResponseDate() {
        return this.handler.getResonseDate();
    }

    protected List listRecords(String listRecordsResumptionToken) throws OAIException {
        List list;
        if (listRecordsResumptionToken == null) {
            throw new BadResumptionTokenException("Resumption Token is not set. This function may only be called to retrieve additional records after the initial ListRecords request with at least one parameter have been performed ");
        }
        InputStream is = null;
        try {
            String qstring = "verb=ListRecords&resumptionToken=" + URLEncoder.encode(listRecordsResumptionToken, "UTF-8");
            this.writeToLog("Performing ListRecords method with resumption token " + listRecordsResumptionToken);
            is = this.sendRequest(qstring);
            this.parser.parse(is, (DefaultHandler)this.handler);
            list = this.handler.getElementList();
        }
        catch (Throwable t) {
            try {
                throw new OAIException(t);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(is);
        return list;
    }

    protected InputStream listSets() throws OAIException {
        try {
            String qstring = "verb=ListSets";
            if (this.listSetsResumptionToken != null) {
                qstring = qstring + "&resumptionToken=" + URLEncoder.encode(this.listSetsResumptionToken, "UTF-8");
            }
            return this.sendRequest(qstring);
        }
        catch (Throwable t) {
            throw new OAIException(t);
        }
    }

    public boolean isGet() {
        return this.isGet;
    }

    public void setGet() {
        this.isGet = true;
    }

    public boolean isPost() {
        return !this.isGet;
    }

    public void setPost() {
        this.isGet = false;
    }

    public Iterator doListRecords(String metadataPrefix, Date from, Date until, String set) throws OAIException, Throwable {
        String fromStr = "";
        String untilStr = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-DD'T'hh:mm:ssZ");
        if (from != null) {
            fromStr = dateFormat.format(from);
        }
        if (until != null) {
            untilStr = dateFormat.format(until);
        }
        return this.doListRecords(metadataPrefix, fromStr, untilStr, set);
    }

    public Iterator doListRecords(String metadataPrefix, String from, String until, String set) throws OAIRequestFailedException, OAIResumptionRequestFailedException {
        try {
            List list = this.listRecords(metadataPrefix, from, until, set);
            String resumptionToken = this.handler.getResumptionToken();
            return new OAIHarvesterIterator(this, list, resumptionToken);
        }
        catch (Exception e) {
            this.writeToLog("The request has failed " + e.getMessage());
            throw new OAIRequestFailedException(e);
        }
    }

    public Iterator doGetRecord(String identifier, String metadataPrefix) throws OAIRequestFailedException {
        try {
            List list = this.getRecord(identifier, metadataPrefix);
            return new OAIHarvesterIterator(this, list, null);
        }
        catch (Exception e) {
            this.writeToLog("The request has failed " + e.getMessage());
            throw new OAIRequestFailedException(e);
        }
    }

    private InputStream sendRequest(String qstring) throws Throwable {
        OutputStreamWriter out = null;
        try {
            Object connection;
            InputStream in;
            if (this.isGet) {
                URL requestDest = new URL(this.url + "?" + qstring);
                this.writeToLog("Sending HTTP GET request to " + this.url + "?" + qstring);
                in = requestDest.openStream();
            } else {
                URL requestDest = new URL(this.url);
                this.writeToLog("Sending HTTP POST request to " + this.url + "with parameters : " + qstring);
                connection = requestDest.openConnection();
                ((URLConnection)connection).setDoInput(true);
                ((URLConnection)connection).setDoOutput(true);
                ((URLConnection)connection).connect();
                out = new OutputStreamWriter(((URLConnection)connection).getOutputStream());
                out.write(qstring);
                out.flush();
                out.close();
                in = ((URLConnection)connection).getInputStream();
            }
            connection = in;
            return connection;
        }
        catch (Throwable t) {
            this.writeToLog(" HTTP request to " + this.url + " with parameters : " + qstring + " had failed");
            throw t;
        }
        finally {
            IOUtil.closeQuietly(out);
        }
    }

    private void writeToLog(String msg) {
        if (this.fsLoad != null) {
            this.fsLoad.writeMsg(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) throws Exception {
        String m_systemHome = System.getProperty("digitool.home");
        OAIHarvester harvester = new OAIHarvester("http://localhost:1801/oai/provider", "com.exlibris.core.infra.common.oai.OAISaxParser");
        Iterator iterator = harvester.doListRecords("dc", "", "", "");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
        }
    }

    public class OAIHarvesterIterator
    implements Iterator {
        private List elementList;
        private int nextIndex = 0;
        private String resumptionToken;
        private OAIHarvester harvester;

        public OAIHarvesterIterator(OAIHarvester harvester, List elementList, String resumptionToken) {
            this.harvester = harvester;
            this.elementList = elementList;
            this.resumptionToken = resumptionToken;
        }

        @Override
        public boolean hasNext() {
            if (this.elementList == null) {
                return false;
            }
            return this.elementList.size() > this.nextIndex || this.resumptionToken != null && !this.resumptionToken.equalsIgnoreCase("");
        }

        public Object next() {
            if (this.elementList == null) {
                return null;
            }
            if (this.elementList.size() > this.nextIndex) {
                Object o = this.elementList.get(this.nextIndex);
                ++this.nextIndex;
                return o;
            }
            if (this.resumptionToken == null || this.resumptionToken.equalsIgnoreCase("")) {
                return null;
            }
            try {
                this.elementList = this.harvester.listRecords(this.resumptionToken);
            }
            catch (OAIException oaie) {
                oaie.printStackTrace();
                this.elementList = null;
            }
            this.resumptionToken = this.harvester.getResumptionToken();
            this.nextIndex = 0;
            return this.next();
        }

        @Override
        public void remove() {
        }
    }
}

