/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.pds;

import com.exlibris.dps.sdk.pds.PdsUserInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class PdsClient {
    private static PdsClient pds = null;
    private String baseUrl = null;
    private boolean isTestMode = false;
    private static final String PDS_HANDLE = "&pds_handle=";
    private static final String AUTHENTICATION_ERROR = "Failed to authenticate user.";

    private PdsClient() {
    }

    public static PdsClient getInstance() {
        if (pds != null) {
            return pds;
        }
        pds = new PdsClient();
        return pds;
    }

    public void init(String baseUrl, boolean isTestMode) {
        this.baseUrl = baseUrl;
        this.isTestMode = isTestMode;
    }

    public String login(String institustion, String user, String password) throws Exception {
        if (this.isTestMode) {
            return "241200811372143992420081372111";
        }
        StringBuffer baseBufferUrl = new StringBuffer();
        baseBufferUrl.append(this.baseUrl);
        StringBuffer dataUrl = new StringBuffer();
        dataUrl.append("func=login-url&institute=").append(institustion).append("&bor_id=").append(user).append("&bor_verification=").append(password);
        URL url = new URL(baseBufferUrl.toString());
        StringBuffer content = this.getUrlContent(url, dataUrl);
        return this.extractPdsHandle(content.toString());
    }

    public String logout(String pdsHandle) throws Exception {
        StringBuffer baseBufferUrl = new StringBuffer();
        baseBufferUrl.append(this.baseUrl);
        StringBuffer dataUrl = new StringBuffer();
        dataUrl.append("func=logout&pds_handle=").append(pdsHandle);
        URL url = new URL(baseBufferUrl.toString());
        StringBuffer content = this.getUrlContent(url, dataUrl);
        return null;
    }

    private StringBuffer getUrlContent(URL url, StringBuffer dataUrl) throws Exception {
        String line;
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(dataUrl.toString());
        wr.flush();
        wr.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF8"));
        StringBuffer content = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            content.append(line);
        }
        bufferedReader.close();
        return content;
    }

    private String extractPdsHandle(String content) throws Exception {
        StringBuffer pdsHandle = new StringBuffer();
        int startPos = content.indexOf(PDS_HANDLE);
        if (startPos < 0) {
            throw new Exception(AUTHENTICATION_ERROR);
        }
        if (!Character.isDigit((content = content.substring(startPos += PDS_HANDLE.length())).charAt(0))) {
            throw new Exception(AUTHENTICATION_ERROR);
        }
        int i = 0;
        while (Character.isDigit(content.charAt(i))) {
            pdsHandle.append(content.charAt(i));
            ++i;
        }
        return pdsHandle.toString();
    }

    public PdsUserInfo getPdsUserByPdsHandle(String pdsHandle) throws Exception {
        if (this.isTestMode) {
            return this.demoPdsUserInfo();
        }
        StringBuffer baseBufferUrl = new StringBuffer();
        baseBufferUrl.append(this.baseUrl);
        StringBuffer dataUrl = new StringBuffer();
        dataUrl.append("func=get-attribute&attribute=BOR_INFO&pds_handle=").append(pdsHandle);
        URL url = new URL(baseBufferUrl.toString());
        return this.parseUserInfo(this.getUrlContent(url, dataUrl).toString());
    }

    private PdsUserInfo demoPdsUserInfo() {
        PdsUserInfo info = new PdsUserInfo();
        info.setUserName("AGENT01");
        info.setBorDeptM("INS01");
        return info;
    }

    private PdsUserInfo parseUserInfo(String xml) throws Exception {
        PdsUserInfo info = new PdsUserInfo();
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(xml));
        Node node = document.selectSingleNode("//bor-info/id");
        if (node != null) {
            info.setUserId(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/name")) != null) {
            info.setUserName(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/group")) != null) {
            info.setBorGroup(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/expiry_date")) != null) {
            info.setExpiryDate(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/bor_dept_m")) != null) {
            info.setBorDeptM(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/bor_group_m")) != null) {
            info.setBorGroup(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/course_enrollment_m")) != null) {
            info.setBorGroupM(node.getText());
        }
        if ((node = document.selectSingleNode("//bor-info/bor_tuples_m")) != null) {
            info.setBorTuplesM(node.getText());
        }
        return info;
    }
}

