/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import net.byteseek.io.reader.WindowReader;
import org.apache.commons.lang.NotImplementedException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class FatFileIdentificationRequest
implements IdentificationRequest<InputStream> {
    private static final int TOP_TAIL_CAPACITY = 0x200000;
    private final String fileName;
    private final String extension;
    private final RequestMetaData requestMetaData;
    private final RequestIdentifier identifier;
    private final Path tempDir;
    private long size;
    private WindowReader reader;

    public FatFileIdentificationRequest(RequestMetaData requestMetaData, RequestIdentifier identifier, Path tempDir) {
        this.requestMetaData = requestMetaData;
        this.identifier = identifier;
        this.size = requestMetaData.getSize();
        this.fileName = requestMetaData.getName();
        this.tempDir = tempDir;
        this.extension = ResourceUtils.getExtension(this.fileName);
    }

    @Override
    public void open(InputStream in) throws IOException {
        this.reader = ResourceUtils.getStreamReader(in, this.tempDir, 0x200000);
        this.size = this.reader.length();
    }

    @Override
    public byte getByte(long position) throws IOException {
        return (byte)this.reader.readByte(position);
    }

    @Override
    public WindowReader getWindowReader() {
        return this.reader;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        throw new NotImplementedException("not implemented");
    }

    @Override
    public RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public RequestIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public Path getTempDir() {
        return this.tempDir;
    }
}

