/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.os;

import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.util.Map;

public abstract class EnvironmentVariable {
    private static String HOME_DIR = ".";
    private static final String EnvVarStartString = "${";
    private static final String EnvVarEndString = "}";

    public static Map<String, String> getAll() {
        return System.getenv();
    }

    public static String get(String name) {
        return EnvironmentVariable.get(name, null);
    }

    public static String get(String name, String ifUndefined) {
        String value = System.getenv(name);
        if (value == null) {
            if (ifUndefined == null) {
                Logger.debug("Undefined environment variable: " + name);
            }
            value = ifUndefined;
        }
        Logger.debug("Retrieving environment variable: '" + name + "' with default: '" + ifUndefined + "' returning: '" + value + "'");
        return value;
    }

    public static String getAsFolder(String name) {
        return EnvironmentVariable.get(name, HOME_DIR);
    }

    public static File getFileTryCurrentContextOnNotFound(String environmentVariableName, String relativeFileName) {
        return new File(EnvironmentVariable.getAsFolder(environmentVariableName) + relativeFileName);
    }

    public static File getFileTryCurrentContextLast(String environmentVariableName, String relativeFileName) {
        File file = new File(EnvironmentVariable.getAsFolder(environmentVariableName) + relativeFileName);
        if (file.isFile()) {
            return file;
        }
        file = new File(HOME_DIR + relativeFileName);
        if (file.isFile()) {
            return file;
        }
        File configFolder = ResourceUtil.getConfigFolder();
        if (configFolder != null) {
            file = new File(configFolder.getParent() + relativeFileName);
        }
        return file.isFile() ? file : null;
    }

    public static String resolveIn(String string) {
        int envVarEndIndex;
        int envVarStartIndex;
        if (string == null || !string.contains(EnvVarStartString) || !string.contains(EnvVarEndString)) {
            return string;
        }
        int startIndex = 0;
        while ((envVarStartIndex = string.indexOf(EnvVarStartString, startIndex)) != -1 && (envVarEndIndex = string.indexOf(EnvVarEndString, envVarStartIndex)) != -1) {
            String envVarName = string.substring(envVarStartIndex + EnvVarStartString.length(), envVarEndIndex);
            String envVarContent = EnvironmentVariable.get(envVarName);
            if (envVarContent == null) {
                envVarContent = "";
            }
            string = string.replace(string.substring(envVarStartIndex, envVarEndIndex + EnvVarEndString.length()), envVarContent);
            startIndex = envVarStartIndex + envVarContent.length();
        }
        return string;
    }
}

