/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.os;

import java.awt.Toolkit;
import java.io.File;
import net.harawata.appdirs.AppDirs;
import net.harawata.appdirs.AppDirsFactory;

public abstract class OperatingSystem {
    private static String OSName;
    private static String OSVersion;
    private static String UserName;
    private static String UserLanguage;
    private static String UserHome;
    private static String JavaTempDir;
    private static Boolean IsWindows;
    private static Boolean IsMacOSX;
    private static Boolean IsLinux;

    public static String osName() {
        OperatingSystem.initializeIfNecessary();
        return OSName;
    }

    public static String osVersion() {
        OperatingSystem.initializeIfNecessary();
        return OSVersion;
    }

    public static String userName() {
        OperatingSystem.initializeIfNecessary();
        return UserName;
    }

    public static String userLanguage() {
        OperatingSystem.initializeIfNecessary();
        return UserLanguage;
    }

    public static String userHome() {
        OperatingSystem.initializeIfNecessary();
        return UserHome;
    }

    public static String getUserDataDir(String appName, String appVersion, String appAuthor) {
        AppDirs appDirs = AppDirsFactory.getInstance();
        return appDirs.getUserDataDir(appName, appVersion, appAuthor);
    }

    public static String javaTempDir() {
        OperatingSystem.initializeIfNecessary();
        return JavaTempDir;
    }

    public static boolean isWindows() {
        OperatingSystem.initializeIfNecessary();
        return IsWindows;
    }

    public static boolean isMacOSX() {
        OperatingSystem.initializeIfNecessary();
        return IsMacOSX;
    }

    public static boolean isLinux() {
        OperatingSystem.initializeIfNecessary();
        return IsLinux;
    }

    public static void beep(Integer times) {
        OperatingSystem.beep(times, 500);
    }

    public static void beep(Integer times, Integer mSexGap) {
        try {
            for (int i = 0; i < times; ++i) {
                OperatingSystem.beep();
                Thread.sleep(mSexGap.intValue());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private static void initializeIfNecessary() {
        if (OSName == null) {
            OperatingSystem.initialize();
        }
    }

    private static void initialize() {
        String osNameLower;
        File javaTempDir;
        OSName = System.getProperty("os.name");
        OSVersion = System.getProperty("os.version");
        UserName = System.getProperty("user.name");
        UserLanguage = System.getProperty("user.language");
        UserHome = System.getProperty("user.home");
        if (!UserHome.endsWith(File.separator)) {
            UserHome = UserHome + File.separator;
        }
        if (!(javaTempDir = new File(JavaTempDir = System.getProperty("java.io.tmpdir"))).exists() && !javaTempDir.mkdirs()) {
            throw new IllegalArgumentException("Invalid value for system property 'java.io.tmpdir' : '" + javaTempDir + "' (Can not create folder !)");
        }
        if (!JavaTempDir.endsWith(File.separator)) {
            JavaTempDir = JavaTempDir + File.separator;
        }
        if ((osNameLower = OSName.toLowerCase()).contains("windows")) {
            IsWindows = true;
        } else if (osNameLower.contains("os x")) {
            IsMacOSX = true;
        } else if (osNameLower.contains("linux")) {
            IsLinux = true;
        }
    }

    static {
        IsWindows = false;
        IsMacOSX = false;
        IsLinux = false;
    }
}

