/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.string;

import java.util.List;
import java.util.Vector;

public class Pattern {
    private static final String RegexMetaCharacters = "[\\^$.|?*+()";
    private static final Character DefaultWildcardMultiple = Character.valueOf('*');
    private static final Character DefaultWildcardSingle = Character.valueOf('?');
    private static final String RegexWildcardMultiple = ".*";
    private static final String RegexWildcardSingle = ".";
    private final List<java.util.regex.Pattern> regexPatterns = new Vector<java.util.regex.Pattern>();

    public Pattern(String ... patterns) {
        this(DefaultWildcardMultiple.charValue(), DefaultWildcardSingle.charValue(), patterns);
    }

    public Pattern(char wildcardMultiple, char wildcardSingle, String ... patterns) {
        for (String pattern : patterns) {
            StringBuilder regexPattern = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                Character c = Character.valueOf(pattern.charAt(i));
                if (c.charValue() == wildcardMultiple) {
                    regexPattern.append(RegexWildcardMultiple);
                    continue;
                }
                if (c.charValue() == wildcardSingle) {
                    regexPattern.append(RegexWildcardSingle);
                    continue;
                }
                if (RegexMetaCharacters.contains(c.toString())) {
                    regexPattern.append("\\").append(c);
                    continue;
                }
                regexPattern.append(c);
            }
            this.regexPatterns.add(java.util.regex.Pattern.compile(regexPattern.toString()));
        }
    }

    public boolean match(String match) {
        for (java.util.regex.Pattern p : this.regexPatterns) {
            if (!p.matcher(match).matches()) continue;
            return true;
        }
        return false;
    }
}

