/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.translations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class I18N {
    public static final String[] AvailableLanguages = new String[]{"de", "en", "fr"};
    private static List<Translator> Translators = new ArrayList<Translator>();

    public static void initialize(String language, String translationResourceBasePath) {
        Translators.add(new Translator(language, translationResourceBasePath));
    }

    public static void clear() {
        Translators.clear();
    }

    public static String translate(String word) {
        if (Translators.isEmpty()) {
            throw new RuntimeException("I18N was not initialized");
        }
        return I18N.doTranslate(word);
    }

    public static String translate_NoCheck(String word) {
        if (Translators.isEmpty()) {
            return word;
        }
        return I18N.doTranslate(word);
    }

    public static String translate(String word, Object ... objects) {
        if (Translators.isEmpty()) {
            throw new RuntimeException("I18N was not initialized");
        }
        return I18N.doTranslate(word, objects);
    }

    public static String translateAndFormat(String translationKey, Object ... arguments) {
        if (Translators.isEmpty()) {
            throw new RuntimeException("I18N was not initialized");
        }
        String value = null;
        for (Translator translator : Translators) {
            value = translator.translateAndFormat(translationKey, arguments);
            if (value == null || value.equals(translationKey)) continue;
            return value;
        }
        return value;
    }

    public static String translate_NoCheck(String word, Object ... objects) {
        if (Translators.isEmpty()) {
            return word;
        }
        return I18N.doTranslate(word, objects);
    }

    private static String doTranslate(String word) {
        String value = null;
        for (Translator translator : Translators) {
            value = translator.translate(word);
            if (value.equals(word)) continue;
            return value;
        }
        return value;
    }

    private static String doTranslate(String word, Object ... objects) {
        String value = null;
        for (Translator translator : Translators) {
            value = translator.translate(word, objects);
            if (value.equals(word)) continue;
            return value;
        }
        return value;
    }

    public static class Translator {
        protected ResourceBundle resources = null;

        public Translator(String language, String translationResourceBasePath) {
            this.resources = ResourceBundle.getBundle(translationResourceBasePath, new Locale(language));
        }

        public String translate(String word) {
            if (this.resources == null) {
                throw new RuntimeException("This translator was not initialized correctly");
            }
            try {
                return this.resources.getString(word);
            }
            catch (Exception x) {
                return word;
            }
        }

        public String translate(String word, Object ... objects) {
            try {
                return String.format(this.translate(word), objects);
            }
            catch (Exception x) {
                return word;
            }
        }

        String translateAndFormat(String translationKey, Object ... arguments) {
            String pattern = this.translate(translationKey);
            if (pattern != null && arguments != null && arguments.length > 0) {
                if (pattern.indexOf("'") > -1) {
                    pattern = pattern.replaceAll("'", "''");
                }
                return MessageFormat.format(pattern, arguments);
            }
            if (pattern != null) {
                return pattern;
            }
            return translationKey;
        }
    }
}

