/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public class ObjectIdentifier {
    private List _moduleList;

    public ObjectIdentifier(List moduleList) {
        this._moduleList = moduleList;
    }

    public void identify(File file, RepInfo info, String parm, boolean verbose, boolean shortCheck) throws IOException {
        ListIterator modIter = this._moduleList.listIterator();
        while (modIter.hasNext()) {
            RepInfo info1 = (RepInfo)info.clone();
            Module mod = (Module)modIter.next();
            try {
                if (!mod.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) continue;
                if (mod.isRandomAccess()) {
                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                    mod.param(parm);
                    if (verbose) {
                        mod.setVerbosity(1);
                    }
                    if (shortCheck) {
                        mod.checkSignatures(file, raf, info1);
                    } else {
                        mod.parse(raf, info1);
                    }
                    raf.close();
                } else {
                    FileInputStream stream = new FileInputStream(file);
                    mod.param(parm);
                    if (shortCheck) {
                        mod.checkSignatures(file, stream, info1);
                    } else {
                        int parseIndex = mod.parse(stream, info1, 0);
                        while (parseIndex != 0) {
                            ((InputStream)stream).close();
                            stream = new FileInputStream(file);
                            parseIndex = mod.parse(stream, info1, parseIndex);
                        }
                    }
                    ((InputStream)stream).close();
                }
            }
            catch (Exception e) {
                continue;
            }
            if (info1.getWellFormed() != 1) continue;
            info.copy(info1);
            break;
        }
    }
}

