/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

public final class ArcConstants {
    protected static final String ARC_FILE = "ARC file";
    protected static final String ARC_RECORD = "ARC record";
    protected static final String ARC_VERSION_BLOCK = "ARC version block";
    public static final int ARC_VB_MAX_TRAILING_NEWLINES = 0x100000;
    public static final int ARC_RECORD_TRAILING_NEWLINES = 1;
    public static final String ARC_MAGIC_HEADER = "filedesc:";
    public static final String ARC_SCHEME = "filedesc";
    protected static byte[] endMark = "\n".getBytes();
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_NO_TYPE = "no-type";
    public static final String VERSION_BLOCK_CONTENT_TYPE = "text";
    public static final String VERSION_BLOCK_MEDIA_TYPE = "plain";
    public static final String ARC_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final String CONTENT_TYPE_FORMAT = "<type>/<sub-type>(; <argument>=<value>)*";
    public static final String FN_URL = "URL";
    public static final String FN_IP_ADDRESS = "IP-address";
    public static final String FN_ARCHIVE_DATE = "Archive-date";
    public static final String FN_CONTENT_TYPE = "Content-type";
    public static final String FN_RESULT_CODE = "Result-code";
    public static final String FN_CHECKSUM = "Checksum";
    public static final String FN_LOCATION = "Location";
    public static final String FN_OFFSET = "Offset";
    public static final String FN_FILENAME = "Filename";
    public static final String FN_ARCHIVE_LENGTH = "Archive-length";
    public static final int FN_IDX_URL = 0;
    public static final int FN_IDX_IP_ADDRESS = 1;
    public static final int FN_IDX_ARCHIVE_DATE = 2;
    public static final int FN_IDX_CONTENT_TYPE = 3;
    public static final int FN_IDX_RESULT_CODE = 4;
    public static final int FN_IDX_CHECKSUM = 5;
    public static final int FN_IDX_LOCATION = 6;
    public static final int FN_IDX_OFFSET = 7;
    public static final int FN_IDX_FILENAME = 8;
    public static final String FN_VERSION_NUMBER = "Version-number";
    public static final String FN_RESERVED = "Reserved";
    public static final String FN_ORIGIN_CODE = "Origin-code";
    public static final int FN_IDX_VERSION_NUMBER = 0;
    public static final int FN_IDX_RESERVED = 1;
    public static final int FN_IDX_ORIGIN_CODE = 2;
    public static final String[] VERSION_1_BLOCK_FIELDS = new String[]{"URL", "IP-address", "Archive-date", "Content-type", "Archive-length"};
    public static final String[] VERSION_2_BLOCK_FIELDS = new String[]{"URL", "IP-address", "Archive-date", "Content-type", "Result-code", "Checksum", "Location", "Offset", "Filename", "Archive-length"};
    public static final int VERSION_1_BLOCK_NUMBER_FIELDS = VERSION_1_BLOCK_FIELDS.length;
    public static final int VERSION_2_BLOCK_NUMBER_FIELDS = VERSION_2_BLOCK_FIELDS.length;
    public static final String[] VERSION_DESC_FIELDS = new String[]{"Version-number", "Reserved", "Origin-code"};
    public static final String VERSION_1_BLOCK_DEF = ArcConstants.join(' ', VERSION_1_BLOCK_FIELDS);
    public static final String VERSION_2_BLOCK_DEF = ArcConstants.join(' ', VERSION_2_BLOCK_FIELDS);

    protected ArcConstants() {
    }

    public static String join(char sep, String ... elts) {
        StringBuilder buf = new StringBuilder();
        for (String s : elts) {
            buf.append(s).append(sep);
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }
}

