/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.edidoc;

import ch.docuteam.mapping.edidoc.RequiredPropertyNotFoundException;
import ch.docuteam.tools.out.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class EdidocReflectionUtils {
    public static String getProperty(Object object, String propertyAccessor) {
        Object traversedObject = object;
        for (String propName : propertyAccessor.split("\\.")) {
            Optional<Object> prop = EdidocReflectionUtils.getValueForField(traversedObject, propName);
            if (!prop.isPresent()) {
                throw new RequiredPropertyNotFoundException("Property '" + propName + "' was not found on object '" + EdidocReflectionUtils.getClassNameForObject(traversedObject) + "'");
            }
            traversedObject = prop.get();
        }
        return traversedObject.toString();
    }

    public static Optional<Object> getValueForField(Object objectContainingField, String fieldName) {
        Optional<Object> valueForField = EdidocReflectionUtils.getValueForField(objectContainingField, fieldName, "get");
        if (valueForField.isPresent()) {
            return valueForField;
        }
        return EdidocReflectionUtils.getValueForField(objectContainingField, fieldName, "is");
    }

    private static Optional<Object> getValueForField(Object objectContainingField, String fieldName, String methodPrefix) {
        String methodName = methodPrefix + StringUtils.capitalize((String)fieldName);
        try {
            Method method = objectContainingField.getClass().getMethod(methodName, new Class[0]);
            return Optional.ofNullable(method.invoke(objectContainingField, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            Logger.debug((Object)("Failed to get value for field '" + fieldName + "' with accessor " + methodName + " from '" + objectContainingField.getClass().getName() + "'"), (Throwable)ex);
            return Optional.empty();
        }
    }

    public static String getClassNameForObject(Object objectToExport) {
        ArrayList<String> names = new ArrayList<String>();
        Class<?> objClass = objectToExport.getClass();
        names.add(0, objClass.getSimpleName());
        do {
            if ((objClass = objClass.getEnclosingClass()) == null) continue;
            names.add(0, objClass.getSimpleName());
        } while (objClass != null);
        return String.join((CharSequence)".", names);
    }
}

