/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public class FragmentInputStream
extends InputStream {
    private List<long[]> _fragments;
    private RandomAccessFile _raf;
    private ListIterator<long[]> fragIterator;
    private long[] curFragment;
    byte[] fragBuffer;
    private int bufOffset;
    private int fragOffset;
    private int _bufSize;
    private int bufBytes;

    public FragmentInputStream(List<long[]> fragments, RandomAccessFile raf) {
        this._fragments = fragments;
        this._raf = raf;
        this.init(-1);
    }

    public FragmentInputStream(List<long[]> fragments, RandomAccessFile raf, int bufSize) {
        this._fragments = fragments;
        this._raf = raf;
        this.init(bufSize);
    }

    private void init(int bufSize) {
        this.fragIterator = this._fragments.listIterator();
        if (bufSize <= 0) {
            bufSize = 8192;
        }
        this._bufSize = bufSize;
        this.fragBuffer = new byte[bufSize];
        this.bufOffset = 0;
        this.bufBytes = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.bufOffset >= this.bufBytes) {
            if (this.curFragment == null || (long)this.fragOffset >= this.curFragment[1]) {
                if (this.fragIterator.hasNext()) {
                    this.curFragment = this.fragIterator.next();
                    this.fragOffset = 0;
                } else {
                    return -1;
                }
            }
            this._raf.seek(this.curFragment[0] + (long)this.fragOffset);
            this.bufBytes = this._raf.read(this.fragBuffer);
            this.fragOffset += this.bufBytes;
            this.bufOffset = 0;
        }
        return this.fragBuffer[this.bufOffset++];
    }
}

