/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.Vector;

public final class Destination {
    private boolean _indirect;
    private PdfSimpleObject _indirectDest;
    private PdfDictionary _pageDest;

    public Destination(PdfObject destObj, PdfModule module, boolean named) throws PdfException {
        block5: {
            try {
                if (!named && destObj instanceof PdfSimpleObject) {
                    this._indirect = true;
                    this._indirectDest = (PdfSimpleObject)destObj;
                    break block5;
                }
                if (destObj instanceof PdfArray) {
                    this._indirect = false;
                    Vector<PdfObject> v = ((PdfArray)destObj).getContent();
                    this._pageDest = (PdfDictionary)module.resolveIndirectObject(v.elementAt(0));
                    break block5;
                }
                if (named && destObj instanceof PdfDictionary) {
                    PdfArray destArray = (PdfArray)((PdfDictionary)destObj).get("D");
                    this._indirect = false;
                    Vector<PdfObject> v = destArray.getContent();
                    this._pageDest = (PdfDictionary)module.resolveIndirectObject(v.elementAt(0));
                    break block5;
                }
                throw new Exception("");
            }
            catch (Exception e) {
                throw new PdfInvalidException("Invalid destination object");
            }
        }
    }

    public boolean isIndirect() {
        return this._indirect;
    }

    public PdfSimpleObject getIndirectDest() {
        return this._indirectDest;
    }

    public PdfDictionary getPageDest() {
        return this._pageDest;
    }

    public int getPageDestObjNumber() throws NullPointerException {
        return this._pageDest.getObjNumber();
    }
}

