/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITBLP1
extends TiffProfileClassIT {
    public TiffProfileClassITBLP1() {
        this._profileText = "TIFF/IT-BL/P1 (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesNewSubfileType(tifd, 0L)) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps[0] != 1) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 32898)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 0)) {
            return false;
        }
        if (!this.satisfiesOrientation(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        int[] valueVec = tifd.getImageColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        if (!this.satisfiesImageColorIndicator(tifd, valueVec)) {
            return false;
        }
        valueVec = tifd.getBackgroundColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        if (!this.satisfiesBackgroundColorIndicator(tifd, valueVec)) {
            return false;
        }
        return tifd.getDocumentName() == null && niso.getScannerModelName() == null && tifd.getPageName() == null && niso.getHostComputer() == null && tifd.getSite() == null && tifd.getColorSequence() == null && tifd.getIT8Header() == null;
    }
}

