/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.out.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;

public class RDFMetadataValue
implements Comparable<RDFMetadataValue> {
    private static final String OBJECT_SKOS_CORE_CONCEPT = "http://www.w3.org/2004/02/skos/core#Concept";
    private static final String PREDICATE_SKOS_CORE_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    static final String PREDICATE_SKOS_CORE_PREF_LABEL = "http://www.w3.org/2004/02/skos/core#prefLabel";
    private final String subjectURI;
    private final String predicateURI;
    private final String objectURI;
    private final String label;
    private String labelEN;
    private final LANGUAGE language;
    private static final String LANGUAGE_FR_FR = "fr-fr";
    private static final String LANGUAGE_EN = "en";

    public static LANGUAGE getSKOSDefaultLanguage() {
        String defaultLanguage = Locale.getDefault().getLanguage();
        if (LANGUAGE.FR.name().toLowerCase().startsWith(defaultLanguage)) {
            return LANGUAGE.FR;
        }
        if (LANGUAGE.EN.name().toLowerCase().startsWith(defaultLanguage)) {
            return LANGUAGE.EN;
        }
        return LANGUAGE.DE;
    }

    private RDFMetadataValue(Resource subjectURI, IRI predicateURI, Value objectURI, LANGUAGE language, Set<String> coreConceptSubjectUriSet) {
        this.subjectURI = subjectURI.stringValue();
        this.predicateURI = predicateURI.stringValue();
        this.label = this.objectURI = RDFMetadataValue.getObjectURI(objectURI, language);
        this.language = language;
    }

    public static RDFMetadataValue createRDFMetadataValue(Statement statement, LANGUAGE language, Set<String> coreConceptSubjectUriSet) {
        Value objectURI;
        IRI predicateURI;
        Resource subjectURI = statement.getSubject();
        if (RDFMetadataValue.isStatementRelevant(subjectURI, predicateURI = statement.getPredicate(), objectURI = statement.getObject(), language, coreConceptSubjectUriSet)) {
            return new RDFMetadataValue(subjectURI, predicateURI, objectURI, language, coreConceptSubjectUriSet);
        }
        return null;
    }

    private static boolean isStatementRelevant(Resource subjectURI, IRI predicateURI, Value objectURI, LANGUAGE language, Set<String> coreConceptSubjectUriSet) {
        return predicateURI.stringValue().equals(PREDICATE_SKOS_CORE_PREF_LABEL) && RDFMetadataValue.getObjectURI(objectURI, language) != null && coreConceptSubjectUriSet.contains(subjectURI.stringValue());
    }

    public static Set<String> getCoreConceptSubjectURIs(Model model) {
        HashSet<String> subjectURIs = new HashSet<String>();
        if (model != null) {
            for (Statement nextStatement : model) {
                if (!nextStatement.getPredicate().stringValue().equals(PREDICATE_SKOS_CORE_TYPE) || !nextStatement.getObject().stringValue().equals(OBJECT_SKOS_CORE_CONCEPT)) continue;
                subjectURIs.add(nextStatement.getSubject().stringValue());
            }
        }
        return subjectURIs;
    }

    private static String getObjectURI(Value objectURI, LANGUAGE language) {
        String objectURIStr = null;
        if (objectURI instanceof SimpleLiteral && ((String)((SimpleLiteral)objectURI).getLanguage().get()).equalsIgnoreCase(language.getValue())) {
            objectURIStr = objectURI.stringValue();
        } else if (objectURI instanceof SimpleLiteral && !((SimpleLiteral)objectURI).getLanguage().isPresent()) {
            objectURIStr = objectURI.stringValue();
        }
        return objectURIStr;
    }

    public String getSubjectURI() {
        return this.subjectURI;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelEN() {
        return this.labelEN;
    }

    public void setLabelEN(String labelEN) {
        this.labelEN = labelEN;
    }

    public LANGUAGE getLanguage() {
        return this.language;
    }

    public static String getRDFLabelENorDefault(List<RDFMetadataValue> rdfAllowedValues, String subjectURI) {
        if (rdfAllowedValues != null) {
            for (RDFMetadataValue rdfValue : rdfAllowedValues) {
                if (!rdfValue.getSubjectURI().equals(subjectURI)) continue;
                if (rdfValue.getLabelEN() != null) {
                    return rdfValue.getLabelEN();
                }
                return rdfValue.getLabel();
            }
        }
        return "";
    }

    public static String getRDFValue(NodeAbstract metsStructMapNode, String value, String name) {
        String returnValue = value;
        MetadataElement metadataElement = null;
        try {
            metadataElement = metsStructMapNode.getLevel().getDynamicMetadataElement(name).getMetadataElement();
        }
        catch (MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException e) {
            Logger.debug((Object)("cannot retrieve metadataElement with name: " + name));
        }
        if (metadataElement != null && metadataElement.getRdfAllowedValues() != null) {
            returnValue = RDFMetadataValue.getRDFLabelENorDefault(metadataElement.getRdfAllowedValues(), value);
        }
        return returnValue;
    }

    public String toString() {
        return this.label;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objectURI == null ? 0 : this.objectURI.hashCode());
        result = 31 * result + (this.predicateURI == null ? 0 : this.predicateURI.hashCode());
        result = 31 * result + (this.subjectURI == null ? 0 : this.subjectURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDFMetadataValue other = (RDFMetadataValue)obj;
        if (this.objectURI == null ? other.objectURI != null : !this.objectURI.equals(other.objectURI)) {
            return false;
        }
        if (this.predicateURI == null ? other.predicateURI != null : !this.predicateURI.equals(other.predicateURI)) {
            return false;
        }
        return !(this.subjectURI == null ? other.subjectURI != null : !this.subjectURI.equals(other.subjectURI));
    }

    @Override
    public int compareTo(RDFMetadataValue other) {
        if (this.getLabel() != null && other.getLabel() != null) {
            return this.getLabel().compareTo(other.getLabel());
        }
        return 0;
    }

    public static enum LANGUAGE {
        FR("fr-fr"),
        EN("en"),
        DE("de");

        private String value;

        private LANGUAGE(String value_) {
            this.value = value_;
        }

        String getValue() {
            return this.value;
        }
    }
}

