/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import java.io.IOException;
import net.byteseek.io.reader.cache.AbstractFreeNotificationCache;
import net.byteseek.io.reader.cache.WindowCache;
import net.byteseek.io.reader.windows.Window;

public final class DoubleCache
extends AbstractFreeNotificationCache
implements WindowCache.WindowObserver {
    private final WindowCache memoryCache;
    private final WindowCache persistentCache;

    public static DoubleCache create(WindowCache memoryCache, WindowCache persistentCache) {
        DoubleCache doubleCache = new DoubleCache(memoryCache, persistentCache);
        persistentCache.subscribe(doubleCache);
        return doubleCache;
    }

    private DoubleCache(WindowCache memoryCache, WindowCache persistentCache) {
        this.memoryCache = memoryCache;
        this.persistentCache = persistentCache;
    }

    @Override
    public Window getWindow(long position) throws IOException {
        Window window = this.memoryCache.getWindow(position);
        if (window == null && (window = this.persistentCache.getWindow(position)) != null) {
            this.memoryCache.addWindow(window);
        }
        return window;
    }

    @Override
    public void addWindow(Window window) throws IOException {
        this.memoryCache.addWindow(window);
        this.persistentCache.addWindow(window);
    }

    @Override
    public void clear() throws IOException {
        IOException memCacheException = null;
        try {
            this.memoryCache.clear();
        }
        catch (IOException ex) {
            memCacheException = ex;
        }
        this.persistentCache.clear();
        if (memCacheException != null) {
            throw memCacheException;
        }
    }

    @Override
    public void windowFree(Window window, WindowCache fromCache) throws IOException {
        this.notifyWindowFree(window, this);
    }

    public WindowCache getMemoryCache() {
        return this.memoryCache;
    }

    public WindowCache getPersistentCache() {
        return this.persistentCache;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[memory cache: " + this.memoryCache + " persistent cache: " + this.persistentCache + ']';
    }
}

