/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.InvertibleMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class SetBitsetMatcher
extends InvertibleMatcher {
    private final BitSet byteValues = new BitSet(256);

    public SetBitsetMatcher(Set<Byte> values, boolean inverted) {
        super(inverted);
        ArgUtils.checkNullOrEmptyCollection(values, "values");
        for (Byte b : values) {
            this.byteValues.set((int)(b & 0xFF));
        }
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        Window window = reader.getWindow(matchPosition);
        return window == null ? false : this.byteValues.get(window.getByte(reader.getWindowOffset(matchPosition)) & 0xFF) ^ this.inverted;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return matchPosition >= 0 && matchPosition < bytes.length && this.byteValues.get(bytes[matchPosition] & 0xFF) ^ this.inverted;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        return this.byteValues.get(bytes[matchPosition] & 0xFF) ^ this.inverted;
    }

    @Override
    public boolean matches(byte theByte) {
        return this.byteValues.get(theByte & 0xFF) ^ this.inverted;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        StringBuilder regularExpression = new StringBuilder();
        if (this.inverted) {
            regularExpression.append('^');
        }
        regularExpression.append('[');
        boolean firstItem = true;
        for (int byteIndex = 0; byteIndex < 256; ++byteIndex) {
            if (!this.byteValues.get(byteIndex)) continue;
            if (prettyPrint && !firstItem) {
                regularExpression.append(' ');
            }
            regularExpression.append(ByteUtils.byteToString(prettyPrint, byteIndex));
            firstItem = false;
        }
        regularExpression.append(']');
        return regularExpression.toString();
    }

    @Override
    public byte[] getMatchingBytes() {
        byte[] values = new byte[this.getNumberOfMatchingBytes()];
        int byteIndex = 0;
        for (int value = 0; value < 256; ++value) {
            if (!(this.byteValues.get(value) ^ this.inverted)) continue;
            values[byteIndex++] = (byte)value;
        }
        return values;
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return this.inverted ? 256 - this.byteValues.cardinality() : this.byteValues.cardinality();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bitset:" + this.byteValues + " inverted: " + this.inverted + ']';
    }
}

