/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.HashMap;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.util.Library;

public class Permissions
extends Dictionary {
    public static final Name DOC_MDP_KEY = new Name("DocMDP");
    public static final Name UR3_KEY = new Name("UR3");
    public static final Name UR_KEY = new Name("UR");

    public Permissions(Library library, HashMap entries) {
        super(library, entries);
    }

    public boolean isDocMDP() {
        return this.library.getObject(this.entries, DOC_MDP_KEY) != null;
    }

    public boolean isUR3() {
        return this.library.getObject(this.entries, UR3_KEY) != null;
    }

    public boolean isUR() {
        return this.library.getObject(this.entries, UR_KEY) != null;
    }

    public SignatureDictionary getSignatureDictionary() {
        if (this.isDocMDP()) {
            return new SignatureDictionary(this.library, this.library.getDictionary(this.entries, DOC_MDP_KEY));
        }
        if (this.isUR3()) {
            return new SignatureDictionary(this.library, this.library.getDictionary(this.entries, UR3_KEY));
        }
        if (this.isUR()) {
            return new SignatureDictionary(this.library, this.library.getDictionary(this.entries, UR_KEY));
        }
        return null;
    }
}

