/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.wizard;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.wizard.SimpleWizard;
import com.exlibris.core.infra.svc.api.wizard.WizardApi;
import com.exlibris.core.web.wizard.xmlbeans.WizardDocument;
import java.io.FileInputStream;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;

public class WizardManager {
    private static final ExLogger log = ExLogger.getExLogger(WizardManager.class);

    public static void deleteWizard(String id, HttpSession session) {
        session.removeAttribute(id);
    }

    public static WizardApi getWizardById(String id, HttpSession session) {
        WizardApi wizard = null;
        if (id != null) {
            wizard = (WizardApi)session.getAttribute(id);
        }
        return wizard;
    }

    public static WizardApi getWizardByName(String wizardName, Locale locale) {
        WizardDocument.Wizard wizard = WizardManager.readFromDB(wizardName);
        if (wizard == null) {
            wizard = WizardManager.readFromDisk(wizardName);
        }
        return new SimpleWizard(wizardName, wizard, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WizardDocument.Wizard readFromDisk(String wizardName) {
        WizardDocument.Wizard wizard = null;
        wizardName = wizardName.replaceAll("\\.", "/");
        wizardName = wizardName + ".xml";
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(Thread.currentThread().getContextClassLoader().getResource(wizardName).getFile());
            wizard = WizardDocument.Factory.parse(inputStream).getWizard();
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtil.closeQuietly(inputStream);
        }
        IOUtil.closeQuietly(inputStream);
        return wizard;
    }

    private static WizardDocument.Wizard readFromDB(String wizardName) {
        WizardDocument.Wizard wizard = null;
        FileTableManager fileTableManager = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
        String wizardXML = null;
        try {
            wizardXML = fileTableManager.getFileByKeyAsString(wizardName, "CRS00");
            if (StringUtils.isNotEmpty((String)wizardXML)) {
                wizard = WizardDocument.Factory.parse(wizardXML).getWizard();
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return wizard;
    }

    public static void saveWizardInstance(WizardApi wizard, HttpSession session) {
        session.setAttribute(wizard.getWizardId(), (Object)wizard);
    }
}

