/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.sunraster.RLEInputStream;
import com.sun.jimi.core.decoder.sunraster.SunRasterColorMap;
import com.sun.jimi.core.decoder.sunraster.SunRasterHeader;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SunRasterDecoder
extends JimiDecoderBase {
    DataInputStream lin;
    AdaptiveRasterImage sinkImage;
    SunRasterHeader header;
    SunRasterColorMap colormap;
    int state;
    private static final int RLE_ESCAPE = 128;

    protected void RLEDecodeImage() throws IOException, JimiException {
        RLEInputStream rLEInputStream = new RLEInputStream(this.lin);
        byte[] byArray = new byte[this.header.Width];
        boolean bl = byArray.length % 2 != 0;
        int n = this.header.Height;
        int n2 = 0;
        while (n2 < n) {
            ((InputStream)rLEInputStream).read(byArray);
            if (bl) {
                ((InputStream)rLEInputStream).read();
            }
            SunRasterDecoder.flushOut(byArray, this.sinkImage, n2);
            ++n2;
        }
    }

    private boolean decodeImage() throws IOException, JimiException {
        block24: {
            try {
                if (this.header.Type == 2) {
                    this.RLEDecodeImage();
                    break block24;
                }
                int n = this.header.Width * this.header.Depth;
                if (n % 16 != 0) {
                    n += 16 - n % 16;
                }
                n /= 8;
                if (this.header.Depth == 8) {
                    byte[] byArray = new byte[this.header.Width];
                    int n2 = 0;
                    while (n2 < this.header.Height) {
                        this.lin.readFully(byArray, 0, this.header.Width);
                        this.lin.skipBytes(n - byArray.length);
                        this.sinkImage.setChannel(0, n2, byArray);
                        this.setProgress(n2 * 100 / this.header.Height);
                        ++n2;
                    }
                    break block24;
                }
                if (this.header.Depth == 4) {
                    byte[] byArray = new byte[this.header.Width];
                    int n3 = 0;
                    while (n3 < this.header.Height) {
                        int n4 = 0;
                        while (n4 < byArray.length) {
                            byte by = this.lin.readByte();
                            byArray[n4] = (byte)(by >> 4);
                            byArray[n4 + 1] = (byte)(by & 0xF);
                            n4 += 2;
                        }
                        this.lin.skipBytes(n - byArray.length / 2);
                        this.sinkImage.setChannel(0, n3, byArray);
                        this.setProgress(n3 * 100 / this.header.Height);
                        ++n3;
                    }
                    break block24;
                }
                if (this.header.Depth < 8) break block24;
                if (this.header.Depth == 16) {
                    int[] nArray = new int[this.header.Width];
                    int n5 = 0;
                    while (n5 < this.header.Height) {
                        int n6 = 0;
                        while (n6 < nArray.length) {
                            nArray[n6] = this.lin.readInt();
                            ++n6;
                        }
                        this.lin.skipBytes(n - nArray.length * 2);
                        this.sinkImage.setChannel(n5, nArray);
                        this.setProgress(n5 * 100 / this.header.Height);
                        ++n5;
                    }
                    break block24;
                }
                if (this.header.Depth < 16) break block24;
                if (this.header.Depth == 24) {
                    int[] nArray = new int[this.header.Width];
                    int n7 = 0;
                    while (n7 < this.header.Height) {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        if (this.header.Type == 3) {
                            n11 = 0;
                            while (n11 < nArray.length) {
                                n10 = this.lin.readUnsignedByte();
                                n9 = this.lin.readUnsignedByte();
                                n8 = this.lin.readUnsignedByte();
                                nArray[n11] = n10 << 16 | n9 << 8 | n8;
                                ++n11;
                            }
                        } else {
                            n11 = 0;
                            while (n11 < nArray.length) {
                                n10 = this.lin.readUnsignedByte();
                                n9 = this.lin.readUnsignedByte();
                                n8 = this.lin.readUnsignedByte();
                                nArray[n11] = n8 << 16 | n9 << 8 | n10;
                                ++n11;
                            }
                        }
                        this.lin.skipBytes(n - nArray.length * 3);
                        this.sinkImage.setChannel(n7, nArray);
                        this.setProgress(n7 * 100 / this.header.Height);
                        ++n7;
                    }
                    break block24;
                }
                if (this.header.Depth != 32) break block24;
                int[] nArray = new int[this.header.Width];
                int n12 = 0;
                while (n12 < this.header.Height) {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    if (this.header.Type == 3) {
                        n16 = 0;
                        while (n16 < nArray.length) {
                            this.lin.readByte();
                            n15 = this.lin.readUnsignedByte();
                            n14 = this.lin.readUnsignedByte();
                            n13 = this.lin.readUnsignedByte();
                            nArray[n16] = n15 << 16 | n14 << 8 | n13;
                            ++n16;
                        }
                    } else {
                        n16 = 0;
                        while (n16 < nArray.length) {
                            this.lin.readByte();
                            n15 = this.lin.readUnsignedByte();
                            n14 = this.lin.readUnsignedByte();
                            n13 = this.lin.readUnsignedByte();
                            nArray[n16] = n13 << 16 | n14 << 8 | n15;
                            ++n16;
                        }
                    }
                    this.lin.skipBytes(n - nArray.length * 4);
                    this.sinkImage.setChannel(n12, nArray);
                    this.setProgress(n12 * 100 / this.header.Height);
                    ++n12;
                }
            }
            catch (JimiException jimiException) {
                throw jimiException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        this.state |= 4;
        return true;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.sinkImage = this.getJimiImage();
            if (this.state == 0) {
                this.header = new SunRasterHeader(this.lin);
                if (this.header.ColorMapType != 0) {
                    this.colormap = new SunRasterColorMap(this.lin, this.header);
                } else if (this.header.ColorMapType == 2) {
                    throw new JimiException("Unsupported Format Subtype");
                }
                this.initJimiImage();
                this.state |= 2;
                return true;
            }
            if (this.decodeImage()) {
                this.state |= 4;
            }
            this.sinkImage.addFullCoverage();
        }
        catch (JimiException jimiException) {
            this.state |= 1;
            throw jimiException;
        }
        catch (IOException iOException) {
            this.state |= 1;
            throw new JimiException("IOException while reading file : " + iOException.toString());
        }
        return false;
    }

    private static void flushOut(byte[] byArray, AdaptiveRasterImage adaptiveRasterImage, int n) throws JimiException {
        adaptiveRasterImage.setChannel(0, n, byArray);
    }

    public void freeDecoder() throws JimiException {
        this.lin = null;
        this.sinkImage = null;
        this.header = null;
        this.colormap = null;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.sinkImage;
    }

    public int getState() {
        return this.state;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        if (inputStream == null || adaptiveRasterImage == null) {
            throw new IllegalArgumentException("Null values to constructor.");
        }
        this.lin = new DataInputStream(inputStream);
        this.sinkImage = adaptiveRasterImage;
        this.state = 0;
    }

    private void initJimiImage() throws JimiException {
        this.sinkImage.setSize(this.header.Width, this.header.Height);
        if (this.colormap == null) {
            int n = 0;
            int n2 = this.header.Depth / 3;
            while (n2 > 0) {
                n <<= 1;
                ++n;
                --n2;
            }
            this.sinkImage.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
        } else if (this.colormap.RGBType) {
            this.sinkImage.setColorModel(new IndexColorModel(8, this.colormap.tableLength, this.colormap.r, this.colormap.g, this.colormap.b));
        } else {
            this.sinkImage.setColorModel(new IndexColorModel(8, this.colormap.tableLength, this.colormap.raw, 0, false));
        }
        this.sinkImage.setPixels();
    }

    public boolean usesChanneledData() {
        return true;
    }
}

