/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public abstract class BinaryValueOperator
extends AbstractQueryModelNode
implements ValueExpr {
    protected ValueExpr leftArg;
    protected ValueExpr rightArg;

    protected BinaryValueOperator() {
    }

    protected BinaryValueOperator(ValueExpr leftArg, ValueExpr rightArg) {
        this.setLeftArg(leftArg);
        this.setRightArg(rightArg);
    }

    public ValueExpr getLeftArg() {
        return this.leftArg;
    }

    public void setLeftArg(ValueExpr leftArg) {
        assert (leftArg != null) : "leftArg must not be null";
        leftArg.setParentNode(this);
        this.leftArg = leftArg;
    }

    public ValueExpr getRightArg() {
        return this.rightArg;
    }

    public void setRightArg(ValueExpr rightArg) {
        assert (rightArg != null) : "rightArg must not be null";
        rightArg.setParentNode(this);
        this.rightArg = rightArg;
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.leftArg.visit(visitor);
        this.rightArg.visit(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.leftArg == current) {
            this.setLeftArg((ValueExpr)replacement);
        } else if (this.rightArg == current) {
            this.setRightArg((ValueExpr)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BinaryValueOperator) {
            BinaryValueOperator o = (BinaryValueOperator)other;
            return this.leftArg.equals(o.getLeftArg()) && this.rightArg.equals(o.getRightArg());
        }
        return false;
    }

    public int hashCode() {
        return this.leftArg.hashCode() ^ this.rightArg.hashCode();
    }

    @Override
    public BinaryValueOperator clone() {
        BinaryValueOperator clone = (BinaryValueOperator)super.clone();
        clone.setLeftArg(this.getLeftArg().clone());
        clone.setRightArg(this.getRightArg().clone());
        return clone;
    }
}

