/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.helpers;

import java.util.Set;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;

class RDFSailRemover
extends AbstractRDFHandler {
    private final SailConnection con;
    private final ValueFactory vf;
    private final UpdateContext uc;
    private Resource[] contexts = new Resource[0];

    public RDFSailRemover(SailConnection con, ValueFactory vf, UpdateContext uc) {
        this.con = con;
        this.vf = vf;
        this.uc = uc;
    }

    public void enforceContext(Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.contexts = contexts;
    }

    public boolean enforcesContext() {
        return this.contexts.length != 0;
    }

    public Resource[] getContexts() {
        return this.contexts;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        Resource ctxt = st.getContext();
        try {
            if (this.enforcesContext()) {
                this.con.removeStatement(this.uc, subj, pred, obj, this.contexts);
            } else if (ctxt == null) {
                Set removeGraphs = this.uc.getDataset().getDefaultRemoveGraphs();
                if (!removeGraphs.isEmpty()) {
                    IRI[] ctxts = removeGraphs.toArray(new IRI[removeGraphs.size()]);
                    this.con.removeStatement(this.uc, subj, pred, obj, (Resource[])ctxts);
                } else {
                    this.con.removeStatement(this.uc, subj, pred, obj, new Resource[0]);
                }
            } else {
                this.con.removeStatement(this.uc, subj, pred, obj, new Resource[]{ctxt});
            }
        }
        catch (SailException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

