/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.darc.mets.Document;
import ch.docuteam.packer.gui.FileProperty;
import ch.docuteam.packer.gui.launcher.Column;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.io.FileUtils;

public class SIPTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final List<FileProperty> sips;
    LauncherView launcherView;
    private Path sipDir;
    DirectoryStream.Filter<Path> sipFileFilter = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            boolean isReadable = Files.isReadable(entry);
            boolean isHidden = Files.isHidden(entry) || entry.toString().startsWith(".");
            boolean isFile = Files.isRegularFile(entry, new LinkOption[0]);
            boolean isDir = Files.isDirectory(entry, new LinkOption[0]);
            boolean isZip = entry.toString().toLowerCase().endsWith(".zip");
            boolean containsMets = Files.exists(entry.resolve("mets.xml"), new LinkOption[0]);
            boolean isACopy = entry.getFileName().toString().contains("_COPY_");
            boolean result = isReadable && !isHidden && (isFile && isZip || isDir && containsMets) && !isACopy;
            return result;
        }
    };

    public SIPTableModel(LauncherView launcherView) {
        this.launcherView = launcherView;
        this.sips = new ArrayList<FileProperty>();
        this.readDirContent();
        this.updateSizeAndLockedByColumns();
    }

    public void readDirContent() {
        this.sips.clear();
        this.sipDir = FileSystems.getDefault().getPath(this.launcherView.getSipDirectory(), new String[0]);
        try (DirectoryStream<Path> sipsStream = Files.newDirectoryStream(this.sipDir, this.sipFileFilter);){
            for (Path file : sipsStream) {
                FileProperty fProp = new FileProperty(file.toFile(), true);
                this.sips.add(fProp);
            }
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage(), (Throwable)e);
        }
        Collections.sort(this.sips);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSizeAndLockedByColumns() {
        List<FileProperty> list = this.sips;
        synchronized (list) {
            for (int i = 0; i < this.sips.size(); ++i) {
                SwingWorker worker;
                final int a = i;
                Object value = this.getValueAt(i, Column.SIZE.ordinal());
                if (value.equals("?")) {
                    worker = new SwingWorker<Long, Void>(){
                        private Long size = null;

                        @Override
                        public Long doInBackground() {
                            this.size = FileUtils.sizeOfDirectory((File)SIPTableModel.this.sips.get(a).getFile());
                            return this.size;
                        }

                        @Override
                        public void done() {
                            SIPTableModel.this.sips.get(a).setSize(this.size);
                            SIPTableModel.this.fireTableCellUpdated(a, Column.SIZE.ordinal());
                        }
                    };
                    worker.execute();
                }
                if (!(value = this.getValueAt(i, Column.LOCKED_BY.ordinal())).equals("?")) continue;
                worker = new SwingWorker<String, Void>(){
                    private String lockedBy = null;
                    private Document document = null;

                    @Override
                    public String doInBackground() throws Exception {
                        this.lockedBy = Document.lockedByWhom(SIPTableModel.this.sips.get(a).getFile().getPath());
                        if (this.lockedBy == null) {
                            this.lockedBy = "";
                        } else if (this.lockedBy.equals(System.getProperty("user.name"))) {
                            this.lockedBy = System.getProperty("user.name");
                        } else {
                            this.document = Document.openReadOnly(SIPTableModel.this.sips.get(a).getFile().getPath(), "launcherView");
                            try {
                                if (SIPTableModel.this.sips.get(a).getDocument() != null && SIPTableModel.this.sips.get(a).getDocument().hasSubmittedNodes()) {
                                    this.lockedBy = this.lockedBy != null ? this.lockedBy + "; " + I18N.translate_NoCheck((String)"Submitted") : I18N.translate_NoCheck((String)"Submitted");
                                }
                            }
                            catch (Exception e) {
                                Logger.warn((Object)(I18N.translate((String)"TitleCantReadSIP") + ": " + SIPTableModel.this.sips.get(a).getFile().getPath()), (Throwable)e);
                            }
                        }
                        return this.lockedBy;
                    }

                    @Override
                    public void done() {
                        SIPTableModel.this.sips.get(a).setDocument(this.document);
                        SIPTableModel.this.sips.get(a).setLockedBy(this.lockedBy);
                        SIPTableModel.this.fireTableCellUpdated(a, Column.LOCKED_BY.ordinal());
                    }
                };
                worker.execute();
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.sips.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < Column.values().length) {
            return Column.values()[columnIndex].getName();
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < Column.values().length) {
            return Column.values()[columnIndex].getColumnClass();
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FileProperty fileProperty = this.sips.get(rowIndex);
        if (columnIndex < Column.values().length) {
            Object result = Column.values()[columnIndex].getValue(fileProperty);
            return result;
        }
        return null;
    }

    public FileProperty getSipAtIndex(int rowIndex) {
        if (rowIndex > -1 && rowIndex < this.sips.size()) {
            return this.sips.get(rowIndex);
        }
        return null;
    }

    public int getRowIndexOfSip(FileProperty fileProperty) {
        return this.sips.indexOf(fileProperty);
    }

    public void delteSipAtIndex(int i) {
        if (i > -1 && i < this.sips.size()) {
            this.sips.remove(i);
        }
    }

    public void removeSipFromView(FileProperty fileProperty) {
        int index = this.sips.indexOf(fileProperty);
        this.delteSipAtIndex(index);
        this.fireTableRowsDeleted(index, index);
    }
}

