/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.common;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipal;
import com.exlibris.core.infra.common.security.UserPrincipalRetriever;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.svc.api.UserPreferencesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.sharedsession.SessionHelper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class UserPreferencesHandler {
    private static ExLogger log = ExLogger.getExLogger(UserPreferencesHandler.class);
    private static final String DEFAULT_OWNER = "";

    public static String getUserPreferencesValueForLoggedInUser(String module, String preferencesKey) {
        UserPrincipal userPrincipal = UserPrincipalRetriever.getUserPrincipal();
        if (userPrincipal != null) {
            HFrUser userDetails = userPrincipal.getUserDetails();
            Long userId = userDetails == null ? null : userDetails.getId();
            String owner = userPrincipal.getInstitutionCode();
            return UserPreferencesHandler.getUserPreferencesValue(userId == null ? -1L : userId, module, preferencesKey, owner);
        }
        return null;
    }

    public static String getUserPreferencesValue(long userId, String module, String preferencesKey, String owner) {
        Map modulePreferences;
        HttpServletRequest request = UserPreferencesHandler.getRequest();
        String value = null;
        if (request != null && (modulePreferences = (Map)SessionHelper.getAttribute(request, userId + module)) != null) {
            value = (String)modulePreferences.get(preferencesKey + owner);
        }
        if (value == null) {
            UserPreferencesManager manager = (UserPreferencesManager)ServiceLocator.getInstance().lookUp(UserPreferencesManager.class);
            value = manager.getUserPreferencesParameter(userId, module, preferencesKey, owner);
            if (request != null) {
                HashMap<String, String> modulePreferences2 = (HashMap<String, String>)SessionHelper.getAttribute(request, userId + module);
                if (modulePreferences2 == null) {
                    modulePreferences2 = new HashMap<String, String>();
                }
                if (value == null) {
                    value = DEFAULT_OWNER;
                }
                modulePreferences2.put(preferencesKey + owner, value);
                SessionHelper.setAttribute(request, userId + module, modulePreferences2);
            }
        }
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return value;
    }

    public static String getUserPreferencesOrDefault(long userId, String module, String preferencesKey) throws InfraException {
        return UserPreferencesHandler.getUserPreferencesValue(userId, module, preferencesKey, DEFAULT_OWNER);
    }

    public static int clearUserPreferencesForModule(long userId, String module, String owner) {
        UserPreferencesManager manager = (UserPreferencesManager)ServiceLocator.getInstance().lookUp(UserPreferencesManager.class);
        UserPreferencesHandler.clearUserPreferences(userId, module, owner);
        return manager.clearUserPreferencesForModule(userId, module, owner);
    }

    public static int clearUserPreferencesForUser(long userId) {
        UserPreferencesManager manager = (UserPreferencesManager)ServiceLocator.getInstance().lookUp(UserPreferencesManager.class);
        return manager.clearUserPreferencesForUser(userId);
    }

    public static int clearUsersPreferencesByModuleAndKeyForLoggedInUser(String module, String preferencesKey) {
        UserPreferencesManager manager = (UserPreferencesManager)ServiceLocator.getInstance().lookUp(UserPreferencesManager.class);
        UserPrincipal userPrincipal = UserPrincipalRetriever.getUserPrincipal();
        if (userPrincipal != null) {
            HFrUser userDetails = userPrincipal.getUserDetails();
            Long userId = userDetails == null ? null : userDetails.getId();
            String owner = userPrincipal.getInstitutionCode();
            UserPreferencesHandler.clearUserPreferences(userId, module, owner);
            return manager.clearUsersPreferencesByModuleAndKey(owner, userId, module, preferencesKey, null);
        }
        return 0;
    }

    public static int clearUsersPreferencesByModuleAndKey(String owner, long userId, String module, String preferencesKey) {
        UserPreferencesManager manager = (UserPreferencesManager)ServiceLocator.getInstance().lookUp(UserPreferencesManager.class);
        UserPreferencesHandler.clearUserPreferences(userId, module, owner);
        return manager.clearUsersPreferencesByModuleAndKey(owner, userId, module, preferencesKey, null);
    }

    public static int clearUsersPreferencesByModuleAndKeyAndValue(String module, String preferencesKey, String preferencesValue, String owner) {
        UserPreferencesManager manager = (UserPreferencesManager)ServiceLocator.getInstance().lookUp(UserPreferencesManager.class);
        UserPreferencesHandler.clearUserPreferences(null, module, owner);
        return manager.clearUsersPreferencesByModuleAndKeyAndValue(module, preferencesKey, preferencesValue, owner);
    }

    private static void clearUserPreferences(Long userid, String module, String owner) {
        HttpServletRequest request = UserPreferencesHandler.getRequest();
        if (userid != null) {
            SessionHelper.setAttribute(request, userid + module, new HashMap());
        } else {
            HFrUser user;
            UserPrincipal principal = UserPrincipalRetriever.getUserPrincipal();
            if (principal != null && (user = principal.getUserDetails()) != null) {
                SessionHelper.setAttribute(request, user.getId() + module, new HashMap());
            }
        }
    }

    public static boolean setUserPreferencesForLoggedInUser(String module, String preferencesKey, String preferencesValue) {
        HFrUser userDetails;
        UserPrincipal userPrincipal = UserPrincipalRetriever.getUserPrincipal();
        if (userPrincipal != null && (userDetails = userPrincipal.getUserDetails()) != null) {
            return UserPreferencesHandler.setUserPreferencesParameter(userDetails.getId(), module, preferencesKey, preferencesValue, userPrincipal.getInstitutionCode());
        }
        return false;
    }

    public static boolean setUserPreferencesForLoggedInUserNoClear(String module, String preferencesKey, String preferencesValue) {
        HFrUser userDetails;
        UserPrincipal userPrincipal = UserPrincipalRetriever.getUserPrincipal();
        if (userPrincipal != null && (userDetails = userPrincipal.getUserDetails()) != null) {
            return UserPreferencesHandler.setUserPreferencesParameterNoClear(userDetails.getId(), module, preferencesKey, preferencesValue, userPrincipal.getInstitutionCode());
        }
        return false;
    }

    public static boolean setUserPreferencesParameter(Long userId, String module, String preferencesKey, String preferencesValue, String owner) {
        return UserPreferencesHandler.setUserPreferencesParameter(userId, module, preferencesKey, preferencesValue, owner, true, true);
    }

    public static boolean setUserPreferencesParameterOnSessionNoClear(Long userId, String module, String preferencesKey, String preferencesValue, String owner) {
        return UserPreferencesHandler.setUserPreferencesParameter(userId, module, preferencesKey, preferencesValue, owner, false, false);
    }

    public static boolean setUserPreferencesParameter(Long userId, String module, String preferencesKey, String preferencesValue, String owner, boolean clear, boolean updateDb) {
        if (userId == null) {
            return false;
        }
        if (clear) {
            UserPreferencesHandler.clearUserPreferences(userId, module, owner);
        }
        return UserPreferencesHandler.setUserPreference(userId, module, preferencesKey, preferencesValue, owner, updateDb);
    }

    private static boolean setUserPreference(Long userId, String module, String preferencesKey, String preferencesValue, String owner) {
        return UserPreferencesHandler.setUserPreference(userId, module, preferencesKey, preferencesValue, owner, true);
    }

    private static boolean setUserPreferenceOnSession(Long userId, String module, String preferencesKey, String preferencesValue, String owner) {
        return UserPreferencesHandler.setUserPreference(userId, module, preferencesKey, preferencesValue, owner, false);
    }

    private static boolean setUserPreference(Long userId, String module, String preferencesKey, String preferencesValue, String owner, boolean updateDb) {
        UserPreferencesManager manager = (UserPreferencesManager)ServiceLocator.getInstance().lookUp(UserPreferencesManager.class);
        HttpServletRequest request = UserPreferencesHandler.getRequest();
        if (request != null) {
            HashMap<String, String> modulePreferences = (HashMap<String, String>)SessionHelper.getAttribute(request, userId + module);
            if (modulePreferences == null) {
                modulePreferences = new HashMap<String, String>();
            }
            modulePreferences.put(preferencesKey + owner, preferencesValue);
            SessionHelper.setAttribute(request, userId + module, modulePreferences);
        }
        if (!updateDb) {
            return true;
        }
        return manager.setUserPreferencesParameter(userId, module, preferencesKey, preferencesValue, owner);
    }

    public static boolean setUserPreferencesParameterNoClear(Long userId, String module, String preferencesKey, String preferencesValue, String owner) {
        if (userId == null) {
            return false;
        }
        return UserPreferencesHandler.setUserPreference(userId, module, preferencesKey, preferencesValue, owner);
    }

    private static HttpServletRequest getRequest() {
        return UserPrincipalRetriever.getHttpRequest();
    }
}

