/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.services.CacheServices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventCacheManager {
    private static final ExLogger log = ExLogger.getExLogger(EventCacheManager.class);
    private static CacheServices cacheServices = null;

    public static void loadCache() {
        try {
            EventCacheManager.loadAnalyzerTypeToCashe();
            EventCacheManager.loadParametersForEventTypeToCache();
            EventCacheManager.loadPropertiesForEventTypeToCache();
            EventCacheManager.loadAnalyzersForEventTypeToCache();
            EventCacheManager.loadIsprovenanceForEventTypeToCache();
            EventCacheManager.loadEventKeysForEventTypeToCache();
            EventCacheManager.loadEventContextForEventTypeToCache();
            log.info("Setting Loaded");
        }
        catch (Throwable e) {
            log.error("Failed to load", e, new String[0]);
        }
    }

    private static void loadAnalyzerTypeToCashe() {
        log.info("Setting Codes For EventAnalyzers");
        ArrayList<String> analyzerType = new ArrayList<String>();
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HCodeTables> codeTables = codeTablesManagerObj.findAllCodeTableByTableName("EventAnalyzers");
        for (HCodeTables row : codeTables) {
            String analyzerClass = row.getDescription();
            analyzerType.add(analyzerClass);
        }
        HashMap<String, ArrayList<String>> analyzerTypeMap = new HashMap<String, ArrayList<String>>();
        analyzerTypeMap.put("/events/analyzerType", analyzerType);
        EventCacheManager.getCacheServices().setCacheValue("/events/analyzerType", analyzerTypeMap, true);
    }

    private static void loadParametersForEventTypeToCache() {
        log.info("Setting Parameters For EventType");
        HashMap<String, ArrayList> parametersForEventType = new HashMap<String, ArrayList>();
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventParameters");
        for (HMappingTables row : mappingTables) {
            ArrayList parameters;
            String eventType = row.getTargetCode();
            if (parametersForEventType.get(eventType) == null) {
                parameters = new ArrayList();
                parameters.add(row.getSourceCode1());
                parametersForEventType.put(eventType, parameters);
                continue;
            }
            parameters = (ArrayList)parametersForEventType.get(eventType);
            parameters.add(row.getSourceCode1());
        }
        EventCacheManager.getCacheServices().setCacheValue("/events/parametersForEventType", parametersForEventType, true);
    }

    private static void loadPropertiesForEventTypeToCache() {
        log.info("Setting Properties For EventType");
        HashMap<String, String[]> propertiesForEventType = new HashMap<String, String[]>();
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventMng");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            String[] properties = new String[]{row.getSourceCode1(), row.getSourceCode2(), row.getSourceCode3(), row.getSourceCode4(), row.getSourceCode5()};
            propertiesForEventType.put(eventType, properties);
        }
        EventCacheManager.getCacheServices().setCacheValue("/events/propertiesForEventType", propertiesForEventType, true);
    }

    private static void loadAnalyzersForEventTypeToCache() {
        log.info("Setting Analyzers For EventType");
        HashMap<String, ArrayList> analyzersForEventType = new HashMap<String, ArrayList>();
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("Analyzer");
        for (HMappingTables row : mappingTables) {
            ArrayList analyzers;
            String eventType = row.getSourceCode1();
            if (analyzersForEventType.get(eventType) == null) {
                analyzers = new ArrayList();
                analyzers.add(row.getTargetCode());
                analyzersForEventType.put(eventType, analyzers);
                continue;
            }
            analyzers = (ArrayList)analyzersForEventType.get(eventType);
            if (analyzers.contains(row.getTargetCode())) continue;
            analyzers.add(row.getTargetCode());
        }
        EventCacheManager.getCacheServices().setCacheValue("/events/analyzersForEventType", analyzersForEventType, true);
    }

    private static void loadIsprovenanceForEventTypeToCache() {
        log.info("Setting Properties For EventTypeProvenance");
        HashMap<String, String> IsProvenanceForEventType = new HashMap<String, String>();
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("isProvenance");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            String properties = row.getSourceCode1();
            IsProvenanceForEventType.put(eventType, properties);
        }
        EventCacheManager.getCacheServices().setCacheValue("/events/IsProvenanceForEventType", IsProvenanceForEventType, true);
    }

    private static void loadEventKeysForEventTypeToCache() {
        log.info("Setting Keys For EventType");
        HashMap eventKeys = new HashMap();
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventKeys");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            if (eventKeys.get(eventType) == null) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(row.getSourceCode1());
                eventKeys.put(eventType, keys);
                continue;
            }
            ((ArrayList)eventKeys.get(eventType)).add(row.getSourceCode1());
        }
        EventCacheManager.getCacheServices().setCacheValue("/events/eventKeys", eventKeys, true);
    }

    private static void loadEventContextForEventTypeToCache() {
        log.info("Setting Context For EventType");
        HashMap eventContext = new HashMap();
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventContext");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            if (eventContext.get(eventType) == null) {
                ArrayList<String> context = new ArrayList<String>();
                context.add(row.getSourceCode1());
                eventContext.put(eventType, context);
                continue;
            }
            ((ArrayList)eventContext.get(eventType)).add(row.getSourceCode1());
        }
        EventCacheManager.getCacheServices().setCacheValue("/events/eventContext", eventContext, true);
    }

    public static HashMap<String, ArrayList<String>> getParametersForEventType() {
        HashMap<String, ArrayList<String>> parametersForEventType = new HashMap();
        try {
            parametersForEventType = (Map)EventCacheManager.getCacheServices().getCache("/events/parametersForEventType");
        }
        catch (Exception e) {
            log.error("failed to retrieve event table from cache", e, new String[0]);
        }
        return parametersForEventType;
    }

    public static HashMap<String, ArrayList<String>> getKeysForEventType() {
        HashMap<String, ArrayList<String>> keysForEventType = new HashMap();
        try {
            keysForEventType = (Map)EventCacheManager.getCacheServices().getCache("/events/eventKeys");
        }
        catch (Exception e) {
            log.error("failed to retrieve event table from cache", e, new String[0]);
        }
        return keysForEventType;
    }

    public static HashMap<String, ArrayList<String>> getContextForEventType() {
        HashMap<String, ArrayList<String>> eventContext = new HashMap();
        try {
            eventContext = (Map)EventCacheManager.getCacheServices().getCache("/events/eventContext");
        }
        catch (Exception e) {
            log.error("failed to retrieve event table from cache", e, new String[0]);
        }
        return eventContext;
    }

    public static HashMap<String, String[]> getPropertiesForEventType() {
        HashMap<String, String[]> propertiesForEventType = new HashMap();
        try {
            propertiesForEventType = (Map)EventCacheManager.getCacheServices().getCache("/events/propertiesForEventType");
        }
        catch (Exception e) {
            log.error("failed to retrieve event table from cache", e, new String[0]);
        }
        return propertiesForEventType;
    }

    public static HashMap<String, ArrayList<String>> getAnalyzersForEventType() {
        HashMap<String, ArrayList<String>> analyzersForEventType = new HashMap();
        try {
            analyzersForEventType = (Map)EventCacheManager.getCacheServices().getCache("/events/analyzersForEventType");
        }
        catch (Exception e) {
            log.error("failed to retrieve event table from cache", e, new String[0]);
        }
        return analyzersForEventType;
    }

    public static HashMap<String, String> getIsProvenanceForEventType() {
        HashMap<String, String> isProvenanceForEventType = new HashMap();
        try {
            isProvenanceForEventType = (Map)EventCacheManager.getCacheServices().getCache("/events/IsProvenanceForEventType");
        }
        catch (Exception e) {
            log.error("failed to retrieve event table from cache", e, new String[0]);
        }
        return isProvenanceForEventType;
    }

    public static ArrayList<String> getAnalyzerType() {
        Map analyzerType = new HashMap();
        try {
            analyzerType = (Map)EventCacheManager.getCacheServices().getCache("/events/analyzerType");
        }
        catch (Exception e) {
            log.error("failed to retrieve event table from cache", e, new String[0]);
        }
        return (ArrayList)analyzerType.get("/events/analyzerType");
    }

    private static CacheServices getCacheServices() {
        if (cacheServices == null) {
            cacheServices = CacheServices.getInstance();
        }
        return cacheServices;
    }
}

