/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.parser;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.sax.SaxRemoveCDATA;
import com.exlibris.core.infra.common.sax.SaxReplaceXsdVersions;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.common.util.StringUtils;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.core.sdk.parser.CoreIEParser;
import com.exlibris.core.sdk.parser.IEParserException;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import gov.loc.mets.AmdSecType;
import gov.loc.mets.FileType;
import gov.loc.mets.MdSecType;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.xmlbeans.StringEnumAbstractBase;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.dom4j.DocumentException;
import org.xml.sax.InputSource;

public class CoreIEParserImpl
implements CoreIEParser {
    private static final String IE = "ie";
    public static final String IE_DMD = "ie-dmd";
    public static final String CMS_DMD = "cms-dmd";
    public static final String COLLECTION_DMD = "collection-dmd";
    public static final String GROUP_ID_PREFIX = "rep";
    public static final String FILE_ID_PREFIX = "fid";
    public static final String STRUCT_MAP_TYPE_PHYSICAL = "PHYSICAL";
    public static final String STRUCT_MAP_TYPE_LOGICAL = "LOGICAL";
    public static final String DIV_TYPE_FILE = "FILE";
    public static final String AMD_SUFFIX = "-amd";
    public static final String STRUCT_MAP_PREFIX = "";
    public static final String TECH_SUFFIX = "-tech";
    public static final String DIGIPROV_SUFFIX = "-digiprov";
    public static final String RIGHTS_SUFFIX = "-rights";
    public static final String SOURCE_SUFFIX = "-source";
    public static final String CONNECTOR = "-";
    private static final String PRESERVATION_MASTER = "PRESERVATION_MASTER";
    private static final String DMD_SUFFIX = "-dmd";
    private static final String DEFAULT_METS_XMLNS = "xmlns=\"http://www.loc.gov/METS/\"";
    private static final String VERSION_ATT = "version";
    protected MetsDocument doc;
    protected MetsDocument.Mets mets;
    protected HashMap<String, AmdSecType> amdMap;
    protected HashMap<String, MdSecType> dmdMap;
    protected HashMap<String, MetsType.FileSec.FileGrp> fileGrpMap;
    protected HashMap<String, FileType> fileTypeMap;
    private ExLogger logger = ExLogger.getExLogger(CoreIEParserImpl.class, "PER");

    protected CoreIEParserImpl(MetsDocument metsDoc) {
        this.doc = metsDoc;
        this.mets = this.doc.getMets();
    }

    protected MetsDocument.Mets getMets() {
        return this.mets;
    }

    @Override
    @Deprecated
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, Enum.PreservationType pt) throws IEParserException {
        return this.addNewFileGrp(ut, pt.name());
    }

    @Override
    public MetsType.FileSec.FileGrp addNewFileGrp(Enum.UsageType ut, String pt) throws IEParserException {
        int newFileGrpCount = this.getFileGrpCount() + 1;
        String id = GROUP_ID_PREFIX + newFileGrpCount;
        if (pt == null) {
            pt = PRESERVATION_MASTER;
        }
        if (ut == null) {
            ut = Enum.UsageType.VIEW;
        }
        if (this.mets.getFileSec() == null) {
            this.mets.addNewFileSec();
        }
        MetsType.FileSec.FileGrp fileGrp = this.mets.getFileSec().addNewFileGrp();
        fileGrp.setID(id);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        fileGrp.setADMID(al);
        this.addFileGrpToMap(fileGrp);
        return fileGrp;
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label) throws IEParserException {
        return this.addNewFile(fileGrp, mimeType, fileLocation, label, null);
    }

    @Override
    public FileType addNewFile(MetsType.FileSec.FileGrp fileGrp, String mimeType, String fileLocation, String label, String groupId) throws IEParserException {
        int newFileCount = this.getFileCount(fileGrp) + 1;
        String id = FILE_ID_PREFIX + newFileCount + CONNECTOR + fileGrp.getID().replace(GROUP_ID_PREFIX, STRUCT_MAP_PREFIX);
        FileType file = fileGrp.addNewFile();
        file.setID(id);
        if (!StringUtils.isEmptyString(groupId)) {
            file.setGROUPID(groupId);
        }
        FileType.FLocat flocat = file.addNewFLocat();
        flocat.setLOCTYPE(FileType.FLocat.LOCTYPE.URL);
        flocat.setHref(fileLocation);
        ArrayList<String> al = new ArrayList<String>();
        al.add(id + AMD_SUFFIX);
        file.setADMID(al);
        this.addFileTypeToMap(file);
        return file;
    }

    @Override
    public FileType[] getFileArray(String fileGrpId) {
        MetsType.FileSec.FileGrp fileGrp = this.getFileGrp(fileGrpId);
        if (fileGrp == null) {
            return null;
        }
        FileType[] fileTypes = null;
        fileTypes = fileGrp.getFileArray();
        return fileTypes;
    }

    @Override
    public MetsType.FileSec.FileGrp[] getFileGrpArray() {
        if (this.mets.getFileSec() == null) {
            return null;
        }
        MetsType.FileSec.FileGrp[] fileGrps = null;
        fileGrps = this.mets.getFileSec().getFileGrpArray();
        return fileGrps;
    }

    @Override
    public StructMapType addNewStructMap(String fileGrpId) throws IEParserException {
        StructMapType[] sms = null;
        sms = this.mets.getStructMapArray();
        for (int i = 0; i < sms.length; ++i) {
            if (!sms[i].getID().equals(fileGrpId + CONNECTOR + 1)) continue;
            this.mets.removeStructMap(i);
            break;
        }
        StructMapType sm = this.mets.addNewStructMap();
        sm.setID(fileGrpId + CONNECTOR + 1);
        sm.setTYPE(STRUCT_MAP_TYPE_PHYSICAL);
        return sm;
    }

    protected StructMapType addAdditionalStructMap(String fileGrpId, Boolean forLocicalTemplate) throws IEParserException {
        String smId = this.getNextStructMapId(fileGrpId);
        StructMapType sm = this.mets.addNewStructMap();
        sm.setID(forLocicalTemplate != false ? STRUCT_MAP_PREFIX : smId);
        sm.setTYPE(forLocicalTemplate != false ? STRUCT_MAP_TYPE_LOGICAL : STRUCT_MAP_TYPE_PHYSICAL);
        return sm;
    }

    protected String getNextStructMapId(String fileGrpId) {
        StructMapType[] sms = this.mets.getStructMapArray();
        ArrayList<String> idsList = new ArrayList<String>();
        for (StructMapType structMap : sms) {
            idsList.add(structMap.getID());
        }
        String smId = null;
        for (int i = 1; i < sms.length + 2 && idsList.contains(smId = fileGrpId + CONNECTOR + i); ++i) {
        }
        return smId;
    }

    @Override
    public StructMapType[] getStructMapArray() {
        if (this.mets != null) {
            StructMapType[] structMapTypes = null;
            structMapTypes = this.mets.getStructMapArray();
            return structMapTypes;
        }
        return null;
    }

    @Override
    public DublinCore getDublinCoreParser() {
        return DublinCoreFactory.getInstance().createDocument();
    }

    @Override
    public MdSecType[] getDmdSecArray() throws IEParserException {
        if (this.mets != null) {
            MdSecType[] dmdSecArray = null;
            dmdSecArray = this.mets.getDmdSecArray();
            return dmdSecArray;
        }
        return null;
    }

    @Override
    public AmdSecType[] getAmdSecArray() throws IEParserException {
        if (this.mets != null) {
            AmdSecType[] amdSecArray = null;
            amdSecArray = this.mets.getAmdSecArray();
            return amdSecArray;
        }
        return null;
    }

    @Override
    public FileType getFile(String id) throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrps = this.getFileGrpArray();
        if (fileGrps == null) {
            return null;
        }
        this.populateFileTypeMap();
        return this.fileTypeMap.get(id);
    }

    protected void addFileTypeToMap(FileType fileType) {
        this.populateFileTypeMap();
        if (this.fileTypeMap.get(fileType.getID()) == null) {
            this.fileTypeMap.put(fileType.getID(), fileType);
        }
    }

    protected void populateFileTypeMap() {
        MetsType.FileSec.FileGrp[] fileGrps = this.getFileGrpArray();
        if (this.fileTypeMap == null && this.mets != null) {
            this.fileTypeMap = new HashMap();
            fileGrps = this.mets.getFileSec().getFileGrpArray();
            for (int i = 0; i < fileGrps.length; ++i) {
                FileType[] fs = this.getFileArray(fileGrps[i].getID());
                for (int j = 0; j < fs.length; ++j) {
                    this.fileTypeMap.put(fs[j].getID(), fs[j]);
                }
            }
        }
    }

    @Override
    public MetsType.FileSec.FileGrp getFileGrp(String id) {
        if (this.mets.getFileSec() == null) {
            return null;
        }
        this.populateFileGrpMap();
        return this.fileGrpMap.get(id);
    }

    protected void addFileGrpToMap(MetsType.FileSec.FileGrp fileGrp) {
        this.populateFileGrpMap();
        if (this.fileGrpMap.get(fileGrp.getID()) == null) {
            this.fileGrpMap.put(fileGrp.getID(), fileGrp);
        }
    }

    protected void populateFileGrpMap() {
        if (this.fileGrpMap == null && this.mets != null) {
            MetsType.FileSec.FileGrp[] fileGrps = null;
            this.fileGrpMap = new HashMap();
            fileGrps = this.mets.getFileSec().getFileGrpArray();
            for (int i = 0; i < fileGrps.length; ++i) {
                this.fileGrpMap.put(fileGrps[i].getID(), fileGrps[i]);
            }
        }
    }

    @Override
    public MetsType.FileSec getFileSec() {
        if (this.mets != null) {
            if (this.mets.getFileSec() == null) {
                this.mets.addNewFileSec();
            }
            return this.mets.getFileSec();
        }
        return null;
    }

    @Override
    public DublinCore getIeDublinCore() throws IEParserException {
        return this.getDMDDC(IE_DMD);
    }

    @Override
    public DublinCore getDMDDC(String dmdId) throws IEParserException {
        this.populateDmdMap();
        MdSecType md = this.getDmdSec(dmdId);
        if (md == null || md.getMdWrap() == null || md.getMdWrap().getXmlData() == null) {
            return null;
        }
        if (((Object)((Object)md.getMdWrap().getMDTYPE())).equals((Object)MdSecType.MdWrap.MDTYPE.DC)) {
            try {
                return DublinCoreFactory.getInstance().createDocument(md.getMdWrap().getXmlData().xmlText());
            }
            catch (DocumentException e) {
                throw new IEParserException(IEParserException.Descriptor.DC_DOCUMENT_EXCEPTION, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setDublinCore(DublinCore dc, String id, boolean useRef, String idForRef, boolean isForWs) throws IEParserException {
        this.setDMDDC(dc, this.formatDmdId(id), useRef, idForRef, isForWs);
        if (this.getFile(id) != null) {
            this.getFile(id).setDMDID(Arrays.asList(this.formatDmdId(id)));
        }
    }

    private String formatDmdId(String id) {
        return id + DMD_SUFFIX;
    }

    @Override
    public void setIEDublinCore(DublinCore dc) throws IEParserException {
        this.setDMDDC(dc, IE_DMD);
    }

    private void setDMDDC(DublinCore dc, String dmdId) throws IEParserException {
        this.setDMDDC(dc, dmdId, false, null, false);
    }

    @Override
    public void setDMDDC(DublinCore dc, String dmdId, boolean useRef, String idForRef, boolean isForWs) throws IEParserException {
        XmlObject xmlObject = null;
        try {
            xmlObject = useRef ? null : XmlObject.Factory.parse((String)dc.toXml());
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
        catch (IOException e) {
            throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
        }
        this.generateDmdSec(useRef, idForRef, MdSecType.MdWrap.MDTYPE.DC, xmlObject, dmdId, isForWs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(String fileName, String xsdOrigVersion) throws IEParserException {
        block12: {
            XmlOptions opt = new XmlOptions();
            opt.setSavePrettyPrint();
            File f = new File(fileName);
            FileWriter fw = null;
            BufferedWriter out = null;
            try {
                GeneralParameterManager gpm;
                String stripCData;
                File parentFile = f.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (Boolean.valueOf(stripCData = (gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class)).getParameter("general", "strip_cdata_from_dc")).booleanValue()) {
                    try {
                        InputSource is = new InputSource();
                        SaxRemoveCDATA parser = new SaxRemoveCDATA("mets:dmdSec", true, true, xsdOrigVersion);
                        is.setCharacterStream(new StringReader(this.doc.xmlText(opt)));
                        parser.parse(is);
                        fw = new FileWriter(f);
                        out = new BufferedWriter(fw);
                        out.write(parser.getIeXml());
                    }
                    catch (Exception e) {
                        try {
                            this.logger.error("could not parse METS", e, new String[0]);
                            this.doc.save(f, opt);
                        }
                        catch (Throwable throwable) {
                            IOUtil.closeQuietly(out);
                            IOUtil.closeQuietly(fw);
                            throw throwable;
                        }
                        IOUtil.closeQuietly(out);
                        IOUtil.closeQuietly(fw);
                        break block12;
                    }
                    IOUtil.closeQuietly(out);
                    IOUtil.closeQuietly(fw);
                    break block12;
                }
                try {
                    SaxReplaceXsdVersions parser = this.useVersionedXml(opt, xsdOrigVersion);
                    fw = new FileWriter(f);
                    out = new BufferedWriter(fw);
                    out.write(parser.getIeXml());
                }
                catch (Exception e) {
                    try {
                        this.logger.error("could not parse METS", e, new String[0]);
                        this.doc.save(f, opt);
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(out);
                        IOUtil.closeQuietly(fw);
                        throw throwable;
                    }
                    IOUtil.closeQuietly(out);
                    IOUtil.closeQuietly(fw);
                    break block12;
                }
                IOUtil.closeQuietly(out);
                IOUtil.closeQuietly(fw);
            }
            catch (IOException e) {
                throw new IEParserException(IEParserException.Descriptor.IO_EXCEPTION, (Throwable)e);
            }
        }
    }

    @Override
    public StructMapType getStructMap(String grpId) {
        StructMapType grpMap = null;
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (smId.startsWith(STRUCT_MAP_PREFIX)) {
                smId = smId.substring(STRUCT_MAP_PREFIX.length());
            }
            if (!structMapArray[i].getTYPE().toUpperCase().equals(STRUCT_MAP_TYPE_PHYSICAL)) continue;
            grpMap = structMapArray[i];
            break;
        }
        if (grpMap == null) {
            grpMap = structMapArray[0];
        }
        return grpMap;
    }

    @Override
    public void generateGID() throws IEParserException {
        if (this.validateCompatible()) {
            MetsType.FileSec.FileGrp[] fileGrp = null;
            try {
                fileGrp = this.mets.getFileSec().getFileGrpArray();
            }
            catch (NullPointerException e) {
                throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
            }
            for (int i = 0; i < fileGrp.length; ++i) {
                FileType[] file = fileGrp[i].getFileArray();
                for (int j = 0; j < file.length; ++j) {
                    file[j].setGROUPID(String.valueOf(j + 1));
                }
            }
        }
    }

    private StructMapType createStructMapType(String value) throws IEParserException {
        Object smt = null;
        try {
            if (value != null && value.contains("<mets:mets xmlns:mets=\"http://www.loc.gov/METS/\">")) {
                return MetsDocument.Factory.parse(value).getMets().getStructMapArray(0);
            }
            return MetsDocument.Factory.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?><mets:mets xmlns:mets=\"http://www.loc.gov/METS/\">" + value + "</mets:mets>").getMets().getStructMapArray(0);
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    @Override
    public void setStructMap(MetsType.FileSec.FileGrp fileGrp, String structMapXml) throws IEParserException {
        structMapXml = structMapXml.replace(DEFAULT_METS_XMLNS, STRUCT_MAP_PREFIX);
        StructMapType newSm = this.createStructMapType(structMapXml);
        this.setStructMap(newSm);
    }

    @Override
    public void setStructMap(StructMapType structMap) throws IEParserException {
        StructMapType[] sms = this.mets.getStructMapArray();
        sms = this.mets.getStructMapArray();
        StructMapType[] structMapArray = new StructMapType[sms.length + 1];
        System.arraycopy(sms, 0, structMapArray, 0, sms.length);
        structMapArray[sms.length] = structMap;
        this.mets.setStructMapArray(structMapArray);
    }

    @Override
    public void addAdditionalStructMap(MetsType.FileSec.FileGrp fileGrp, StructMapType newSm) throws IEParserException {
        StructMapType[] sms = this.mets.getStructMapArray();
        int count = 0;
        for (int i = 0; i < sms.length; ++i) {
            if (!sms[i].getID().substring(0, sms[i].getID().lastIndexOf(CONNECTOR)).equals(fileGrp.getID())) continue;
            ++count;
        }
        newSm.setID(fileGrp.getID() + CONNECTOR + ++count);
        sms = this.mets.getStructMapArray();
        StructMapType[] structMapArray = new StructMapType[sms.length + 1];
        System.arraycopy(sms, 0, structMapArray, 0, sms.length);
        structMapArray[sms.length] = newSm;
        this.mets.setStructMapArray(structMapArray);
    }

    @Override
    public StructMapType getStructMapById(String structMapId) throws IEParserException {
        StructMapType grpMap = null;
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.equals(structMapId)) continue;
            grpMap = structMapArray[i];
            break;
        }
        return grpMap;
    }

    @Override
    public StructMapType[] getStructMapsByFileGrpId(String fileGrpId) {
        StructMapType[] structMapArray = this.getStructMapArray();
        ArrayList<StructMapType> structMapArrayById = new ArrayList<StructMapType>();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.substring(0, smId.lastIndexOf(CONNECTOR)).equals(fileGrpId)) continue;
            structMapArrayById.add(structMapArray[i]);
        }
        StructMapType[] structMapsFileGrp = new StructMapType[structMapArrayById.size()];
        structMapsFileGrp = structMapArrayById.toArray(structMapsFileGrp);
        return structMapsFileGrp;
    }

    @Override
    public void removeFGStructMaps(String grpId) {
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            String smId = structMapArray[i].getID();
            if (!smId.substring(0, smId.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeStructMap(i);
            this.removeFGStructMaps(grpId);
            break;
        }
    }

    @Override
    public void removeStructMap(String smId) {
        StructMapType[] structMapArray = this.getStructMapArray();
        for (int i = 0; i < structMapArray.length; ++i) {
            if (!smId.equals(structMapArray[i].getID())) continue;
            this.mets.removeStructMap(i);
        }
    }

    protected void removeAmdSec(String grpId) throws IEParserException {
        AmdSecType[] amdSecTypeArray = this.getAmdSecArray();
        for (int i = 0; i < amdSecTypeArray.length; ++i) {
            String id = amdSecTypeArray[i].getID();
            if (!id.substring(0, id.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeAmdSec(i);
            this.removeAmdSec(grpId);
            break;
        }
    }

    protected void removeFGDmdSec(String grpId) throws IEParserException {
        MdSecType[] mdSecTypeArray = this.getDmdSecArray();
        for (int i = 0; i < mdSecTypeArray.length; ++i) {
            String id = mdSecTypeArray[i].getID();
            if (!id.substring(0, id.lastIndexOf(CONNECTOR)).equals(grpId)) continue;
            this.mets.removeDmdSec(i);
            this.removeFGDmdSec(grpId);
            break;
        }
    }

    protected void removeFGSec(String grpId) throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrp = this.getFileSec().getFileGrpArray();
        for (int i = 0; i < fileGrp.length; ++i) {
            String id = fileGrp[i].getID();
            if (!id.equals(grpId)) continue;
            this.mets.getFileSec().removeFileGrp(i);
            break;
        }
    }

    @Override
    public String toXML() {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        return this.doc.xmlText(opt);
    }

    @Override
    public void toXML(File file) throws IOException {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        this.doc.save(file, opt);
    }

    @Override
    public String toXML(String xsdVersion) throws Exception {
        XmlOptions opt = new XmlOptions();
        opt.setSavePrettyPrint();
        SaxReplaceXsdVersions parser = this.useVersionedXml(opt, xsdVersion);
        return parser.getIeXml();
    }

    @Override
    public boolean validate(XmlOptions xmloptions) {
        return this.mets.validate(xmloptions);
    }

    @Override
    public boolean validate() {
        return this.mets.validate();
    }

    private SaxReplaceXsdVersions useVersionedXml(XmlOptions opt, String xsdVersion) throws Exception {
        InputSource is = new InputSource();
        SaxReplaceXsdVersions parser = new SaxReplaceXsdVersions(xsdVersion);
        is.setCharacterStream(new StringReader(this.doc.xmlText(opt)));
        parser.parse(is);
        return parser;
    }

    protected MdSecType getDmdSec(String dmdId) {
        return this.dmdMap.get(dmdId);
    }

    protected AmdSecType getAmd(String id, boolean createNew, boolean isForWs) {
        return this.getAmd(id, createNew, false, null, isForWs);
    }

    protected AmdSecType getAmd(String id, boolean createNew, boolean useRef, String idForRef, boolean isForWs) {
        AmdSecType amd = null;
        this.populateAmdMap();
        if (this.amdMap.get(id) == null && createNew) {
            amd = this.createNewAmdSec(id, useRef, idForRef, isForWs);
            this.amdMap.put(id, amd);
        }
        return this.amdMap.get(id);
    }

    protected void addAmdSecToMap(AmdSecType amd) {
        this.populateAmdMap();
        if (this.amdMap.get(amd.getID()) == null) {
            this.amdMap.put(amd.getID(), amd);
        }
    }

    protected void populateAmdMap() {
        AmdSecType[] amds = null;
        if (this.amdMap == null) {
            this.amdMap = new HashMap();
            if (this.mets != null) {
                amds = this.mets.getAmdSecArray();
                for (int i = 0; i < amds.length; ++i) {
                    this.amdMap.put(amds[i].getID(), amds[i]);
                }
            }
        }
    }

    private void populateDmdMap() {
        MdSecType[] dmds = null;
        if (this.dmdMap == null) {
            this.dmdMap = new HashMap();
            if (this.mets != null) {
                dmds = this.mets.getDmdSecArray();
                for (int i = 0; i < dmds.length; ++i) {
                    this.dmdMap.put(dmds[i].getID(), dmds[i]);
                }
            }
        }
    }

    protected AmdSecType createNewAmdSec(String id, boolean isForWs) {
        return this.createNewAmdSec(id, false, null, isForWs);
    }

    @Override
    public AmdSecType createNewAmdSec(String id) {
        AmdSecType amd = null;
        this.populateAmdMap();
        amd = this.mets.addNewAmdSec();
        amd.setID(id);
        this.amdMap.put(id, amd);
        return this.amdMap.get(id);
    }

    protected AmdSecType createNewAmdSec(String id, boolean useRef, String idForRef, boolean isForWs) {
        AmdSecType amd = this.mets.addNewAmdSec();
        if (isForWs) {
            amd.setID(id + "-MID-" + idForRef);
        } else {
            amd.setID(id);
        }
        MdSecType md = amd.addNewTechMD();
        md.setID(id + TECH_SUFFIX);
        this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", null, md);
        md = amd.addNewDigiprovMD();
        md.setID(id + DIGIPROV_SUFFIX);
        this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", null, md);
        md = amd.addNewRightsMD();
        md.setID(id + RIGHTS_SUFFIX);
        this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", null, md);
        return amd;
    }

    protected XmlObject getXmlObject(String xml) throws IEParserException {
        try {
            return XmlObject.Factory.parse((String)xml);
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    protected int getFileGrpCount() throws IEParserException {
        int length;
        if (this.mets.getFileSec() == null) {
            return 0;
        }
        try {
            length = this.mets.getFileSec().getFileGrpArray().length;
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        return length;
    }

    protected int getFileCount(MetsType.FileSec.FileGrp fileGrp) {
        if (fileGrp == null) {
            return 0;
        }
        return fileGrp.getFileArray().length;
    }

    protected boolean validateCompatible() throws IEParserException {
        MetsType.FileSec.FileGrp[] fileGrp = null;
        try {
            fileGrp = this.mets.getFileSec().getFileGrpArray();
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.NO_FILE_SEC, (Throwable)e);
        }
        for (int i = 0; i < fileGrp.length - 1; ++i) {
            if (fileGrp[i].getFileArray().length == fileGrp[i + 1].getFileArray().length) continue;
            return false;
        }
        return true;
    }

    protected void updateAmdIds(String correctId, String currentIdAmdSec) throws IEParserException {
        AmdSecType amdSecType = this.getAmd(currentIdAmdSec, false, false);
        if (amdSecType != null) {
            amdSecType.setID(correctId + AMD_SUFFIX);
            try {
                amdSecType.getTechMDArray(0).setID(correctId + AMD_SUFFIX + TECH_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_TECH_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getDigiprovMDArray(0).setID(correctId + AMD_SUFFIX + DIGIPROV_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_DIGIPROOV_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getRightsMDArray(0).setID(correctId + AMD_SUFFIX + RIGHTS_SUFFIX);
            }
            catch (Exception e) {
                throw new IEParserException(IEParserException.Descriptor.ERROR_IN_RIGHTS_MD_ARRAY, (Throwable)e);
            }
            try {
                amdSecType.getSourceMDArray(0).setID(correctId + AMD_SUFFIX + SOURCE_SUFFIX);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void generateDmdSec(boolean useRef, String idForRef, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String dmdId, boolean isForWs) {
        if (isForWs) {
            dmdId = dmdId + "-MID-" + idForRef;
        }
        this.populateDmdMap();
        MdSecType dmd = this.getDmdSec(dmdId);
        if (dmd == null) {
            dmd = this.mets.addNewDmdSec();
            this.dmdMap.put(dmdId, dmd);
        } else if (useRef) {
            dmd.unsetMdRef();
        } else {
            dmd.unsetMdWrap();
        }
        dmd.setID(dmdId);
        this.addProperWrapRef(useRef, idForRef, mdType, null, xmlObject, dmd);
    }

    protected void addProperWrapRef(boolean useRef, String idForRef, MdSecType.MdWrap.MDTYPE.Enum mdType, String otherType, XmlObject xmlObject, MdSecType secType) {
        if (useRef) {
            secType.addNewMdRef().setID(idForRef);
            secType.getMdRef().setMDTYPE(this.convertMDWrapTypeToMdRefType(mdType));
            if (otherType != null) {
                secType.getMdRef().setOTHERMDTYPE(otherType);
            }
        } else {
            secType.addNewMdWrap().setMDTYPE(mdType);
            if (otherType != null) {
                secType.getMdWrap().setOTHERMDTYPE(otherType);
            }
            secType.getMdWrap().addNewXmlData();
            if (xmlObject != null) {
                secType.getMdWrap().getXmlData().set(xmlObject);
            }
        }
    }

    private MdSecType.MdRef.MDTYPE.Enum convertMDWrapTypeToMdRefType(MdSecType.MdWrap.MDTYPE.Enum mdType) {
        return MdSecType.MdRef.MDTYPE.Enum.forString(mdType.toString());
    }

    protected void updateProperWrapRef(boolean useRef, String idForRef, XmlObject xmlObject, MdSecType secType) {
        if (useRef) {
            secType.getMdRef().setID(idForRef);
        } else {
            secType.getMdWrap().getXmlData().set(xmlObject);
        }
    }

    @Override
    public String getFileDmdId(String id) {
        return this.formatDmdId(id);
    }

    @Override
    public List<MdSecType.MdWrap> getIeSourceMDs() {
        return this.getSourceMDs("ie-amd");
    }

    @Override
    public List<MdSecType.MdWrap> getSourceMDs(String id) {
        ArrayList<MdSecType.MdWrap> mdWraps = new ArrayList<MdSecType.MdWrap>();
        AmdSecType amd = this.getAmd(id, false, false);
        if (amd != null) {
            MdSecType[] sourceMDs;
            for (MdSecType sourceMd : sourceMDs = amd.getSourceMDArray()) {
                MdSecType.MdWrap sourceMdWrap = sourceMd.getMdWrap();
                if (sourceMdWrap == null || this.isDnxMdWrap(sourceMdWrap)) continue;
                mdWraps.add(sourceMdWrap);
            }
        }
        return mdWraps;
    }

    @Override
    public MdSecType[] getIeSourceMDsArray() {
        AmdSecType amd = this.getAmd("ie-amd", false, false);
        MdSecType[] sourceMDs = null;
        if (amd != null) {
            sourceMDs = amd.getSourceMDArray();
        }
        return sourceMDs;
    }

    @Override
    public void setIeSourceMds(MdSecType[] sourceMdsArray) {
        AmdSecType amd = this.getAmd("ie-amd", false, false);
        amd.setSourceMDArray(sourceMdsArray);
    }

    protected boolean isDnxMdWrap(MdSecType.MdWrap mdWrap) {
        return ((Object)((Object)MdSecType.MdWrap.MDTYPE.OTHER)).equals((Object)mdWrap.getMDTYPE()) && "dnx".equals(mdWrap.getOTHERMDTYPE());
    }

    @Override
    public DublinCore getIeCMSDublinCore() throws IEParserException {
        return this.getDMDDC(CMS_DMD);
    }

    @Override
    public void setIeCMSDublinCore(DublinCore dc) throws IEParserException {
        this.setIeCMSDublinCore(dc, false, null);
    }

    @Override
    public void setIeCMSDublinCore(DublinCore dc, boolean useRef, String idForRef) throws IEParserException {
        this.setDMDDC(dc, CMS_DMD, useRef, idForRef, false);
    }

    @Override
    public void setSourceMd(String id, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String mid, boolean useRef, String otherMdType) {
        this.setSourceMd(useRef, mid, id + AMD_SUFFIX, mdType, xmlObject, otherMdType);
    }

    @Override
    public void setIeSourceMd(MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String mid, String otherMdType) {
        this.setSourceMd(false, mid, "ie-amd", mdType, xmlObject, otherMdType);
    }

    protected void setSourceMd(boolean useRef, String mid, String amdId, MdSecType.MdWrap.MDTYPE.Enum mdType, XmlObject xmlObject, String otherMdType) {
        AmdSecType amd = this.getAmd(amdId, true, useRef, mid, false);
        String mdTypeAsString = null;
        Integer mdNumber = 1;
        if (amd != null) {
            MdSecType[] sourceMDs;
            mdTypeAsString = mdType == null ? otherMdType.substring(otherMdType.indexOf(":") + 1, otherMdType.length()) : mdType.toString();
            for (MdSecType sourceMd : sourceMDs = amd.getSourceMDArray()) {
                StringEnumAbstractBase sourceType = null;
                if (useRef) {
                    MdSecType.MdRef sourceMdRef = sourceMd.getMdRef();
                    sourceType = sourceMdRef.getMDTYPE();
                } else {
                    MdSecType.MdWrap sourceMdWrap = sourceMd.getMdWrap();
                    sourceType = sourceMdWrap.getMDTYPE();
                }
                if (!mdTypeAsString.equals(ObjectUtils.toString((Object)sourceType)) && mdType != null) continue;
                Integer n = mdNumber;
                Integer n2 = mdNumber = Integer.valueOf(mdNumber + 1);
            }
        } else {
            amd = this.createNewAmdSec(amdId, useRef, mid, false);
        }
        MdSecType newSourceMD = amd.addNewSourceMD();
        String sourceMDId = null;
        sourceMDId = mid != null && mid.startsWith(amdId + SOURCE_SUFFIX + CONNECTOR) ? mid : StringUtils.concat(new Object[]{amdId, "-source-", mdType, mdType != null ? CONNECTOR : STRUCT_MAP_PREFIX, mdNumber});
        newSourceMD.setID(sourceMDId);
        if (mdType == null) {
            this.addProperWrapRef(useRef, mid, MdSecType.MdWrap.MDTYPE.OTHER, mdTypeAsString, xmlObject, newSourceMD);
        } else {
            this.addProperWrapRef(useRef, mid, mdType, null, xmlObject, newSourceMD);
        }
        this.addAmdSecToMap(amd);
    }

    private void removeFileFromFileGroup(List<String> filesList) {
        MetsType.FileSec.FileGrp[] fileGrps = this.getFileGrpArray();
        block0: for (int i = 0; i < fileGrps.length; ++i) {
            FileType[] files = this.getFileArray(fileGrps[i].getID());
            for (int x = 0; x < files.length; ++x) {
                if (!filesList.contains(files[x].getID())) continue;
                fileGrps[i].removeFile(x);
                this.removeFileFromFileGroup(filesList);
                continue block0;
            }
        }
    }

    @Override
    public void removeFilesFromFG(String grpId, List<String> filesList) throws IEParserException {
        this.removeFileFromFileGroup(filesList);
        block0: for (String fileId : filesList) {
            if (!filesList.contains(fileId)) continue;
            this.removeAmdSec(fileId);
            MdSecType[] mdSecTypeArray = this.getDmdSecArray();
            for (int j = 0; j < mdSecTypeArray.length; ++j) {
                String id = mdSecTypeArray[j].getID();
                if (!id.substring(0, id.lastIndexOf(CONNECTOR)).equals(fileId)) continue;
                this.mets.removeDmdSec(j);
                continue block0;
            }
        }
    }

    @Override
    public void setFileGrpDnx(DnxDocument dnx, String id, boolean useRef, String idForRef, boolean isForWs) throws IEParserException {
        this.setDnx(id, dnx, useRef, idForRef, isForWs);
    }

    @Override
    public void setFileDnx(DnxDocument dnx, String id, boolean useRef, String idForRef, boolean isForWs) throws IEParserException {
        this.setDnx(id, dnx, useRef, idForRef, isForWs);
        FileType file = this.getFile(id);
        if (file != null && file.getADMID() == null) {
            ArrayList<String> al = new ArrayList<String>();
            al.add(file.getID() + AMD_SUFFIX);
            file.setADMID(al);
        }
    }

    @Override
    public void setIeDnx(DnxDocument ieDnxDoc, boolean useRef, String idForRef, boolean isForWs) throws IEParserException {
        this.setDnx(IE, ieDnxDoc, useRef, idForRef, isForWs);
    }

    @Override
    public void setDnx(String id, DnxDocument dnx, boolean useRef, String idForRef, boolean isForWs) throws IEParserException {
        if (dnx == null && !useRef) {
            return;
        }
        AmdSecType amd = this.getAmd(id + AMD_SUFFIX, true, useRef, idForRef, isForWs);
        this.setDnxTechMd(useRef, idForRef, dnx, amd);
        this.setDnxDigiprovMd(useRef, idForRef, dnx, amd);
        this.setDnxRightsMd(useRef, idForRef, dnx, amd);
    }

    private void setDnxSourceMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) {
        try {
            XmlObject xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForSourceMd().toString());
            boolean findDnx = false;
            if (amd.getSourceMDArray().length == 0) {
                MdSecType newSourceMDSec = amd.addNewSourceMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newSourceMDSec);
            } else {
                for (int i = 0; i < amd.getSourceMDArray().length; ++i) {
                    if (!useRef && !amd.getSourceMDArray(i).getMdWrap().getOTHERMDTYPE().equals("dnx")) continue;
                    this.updateProperWrapRef(useRef, idForRef, xObj, amd.getSourceMDArray(i));
                    findDnx = true;
                    break;
                }
                if (!findDnx && !useRef) {
                    MdSecType newSourceMDSec = amd.addNewSourceMD();
                    this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newSourceMDSec);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setDnxRightsMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) throws IEParserException {
        try {
            XmlObject xObj;
            XmlObject xmlObject = xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForRightshMd().toString());
            if (amd.getRightsMDArray().length == 0) {
                MdSecType newRightsMDSec = amd.addNewRightsMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newRightsMDSec);
            } else {
                this.updateProperWrapRef(useRef, idForRef, xObj, amd.getRightsMDArray(0));
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_RIGHTS_MD_ARRAY, (Throwable)e);
        }
    }

    private void setDnxDigiprovMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) throws IEParserException {
        try {
            XmlObject xObj;
            XmlObject xmlObject = xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForDigiprovMd().toString());
            if (amd.getDigiprovMDArray().length == 0) {
                MdSecType newDigiprovMDSec = amd.addNewDigiprovMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newDigiprovMDSec);
            } else {
                this.updateProperWrapRef(useRef, idForRef, xObj, amd.getDigiprovMDArray(0));
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_DIGIPROOV_MD_ARRAY, (Throwable)e);
        }
    }

    private void setDnxTechMd(boolean useRef, String idForRef, DnxDocument dnx, AmdSecType amd) throws IEParserException {
        try {
            XmlObject xObj;
            XmlObject xmlObject = xObj = useRef ? null : this.getXmlObject(dnx.getDnxDocumentForTechMd().toString());
            if (amd.getTechMDArray().length == 0) {
                MdSecType newTechMDSec = amd.addNewTechMD();
                this.addProperWrapRef(useRef, idForRef, MdSecType.MdWrap.MDTYPE.OTHER, "dnx", xObj, newTechMDSec);
            } else {
                this.updateProperWrapRef(useRef, idForRef, xObj, amd.getTechMDArray(0));
            }
        }
        catch (NullPointerException e) {
            throw new IEParserException(IEParserException.Descriptor.ERROR_IN_TECH_MD_ARRAY, (Throwable)e);
        }
    }

    @Override
    public DnxDocument getDnx(String id, boolean isForWs) throws IEParserException {
        if (this.getAmd(id, false, isForWs) != null) {
            return this.getDnx(this.getAmd(id, false, isForWs));
        }
        return null;
    }

    private DnxDocument getDnx(AmdSecType amd) throws IEParserException {
        String dnxVersion;
        DnxDocument techMdDnx = null;
        DnxDocument digiprovMdDnx = null;
        DnxDocument rightsMdDnx = null;
        DnxDocument sourceMdDnx = null;
        try {
            if (amd.getTechMDArray().length != 0) {
                MdSecType.MdWrap techMdWrap = amd.getTechMDArray(0).getMdWrap();
                techMdDnx = this.getDnxFromMdWrap(techMdWrap);
            }
            if (amd.getDigiprovMDArray().length != 0) {
                MdSecType.MdWrap digiprovMdWrap = amd.getDigiprovMDArray(0).getMdWrap();
                digiprovMdDnx = this.getDnxFromMdWrap(digiprovMdWrap);
            }
            if (amd.getRightsMDArray().length != 0 && amd.getRightsMDArray(0).getMdWrap() != null) {
                MdSecType.MdWrap rightsMdWrap = amd.getRightsMDArray(0).getMdWrap();
                rightsMdDnx = this.getDnxFromMdWrap(rightsMdWrap);
            }
            if (amd.getSourceMDArray().length != 0 && amd.getSourceMDArray(0).getMdWrap() != null) {
                MdSecType.MdWrap sourceMdWrap = amd.getSourceMDArray(0).getMdWrap();
                sourceMdDnx = this.getDnxFromMdWrap(sourceMdWrap);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed parsing dnx metadata from METS amd sec " + amd.getID(), new String[0]);
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
        DnxDocument dnx = DnxDocumentFactory.getInstance().createDnxDocument();
        String string = techMdDnx != null ? techMdDnx.getDocument().getRootElement().attributeValue(VERSION_ATT) : (digiprovMdDnx != null ? digiprovMdDnx.getDocument().getRootElement().attributeValue(VERSION_ATT) : (rightsMdDnx != null ? rightsMdDnx.getDocument().getRootElement().attributeValue(VERSION_ATT) : (dnxVersion = sourceMdDnx != null ? sourceMdDnx.getDocument().getRootElement().attributeValue(VERSION_ATT) : null)));
        if (dnxVersion == null && dnx.getDocument().getRootElement().attribute(VERSION_ATT) != null) {
            dnx.getDocument().getRootElement().attribute(VERSION_ATT).detach();
        }
        dnx.mergeDnxDocuments(techMdDnx, digiprovMdDnx, rightsMdDnx, sourceMdDnx);
        return dnx;
    }

    private DnxDocument getDnxFromMdWrap(MdSecType.MdWrap mdWrap) {
        DnxDocument dnx = null;
        if (mdWrap != null && this.isDnxMdWrap(mdWrap)) {
            dnx = DnxDocumentFactory.getInstance().parse(mdWrap.getXmlData().xmlText());
        }
        return dnx;
    }
}

