/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecExternalProcess;
import com.exlibris.digitool.exceptions.ScriptException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ScriptUtil {
    private static final ExLogger logger = ExLogger.getExLogger(ScriptUtil.class);

    public static String runScript(String script, List<String> args) throws ScriptException {
        String loggerMessage = "Execute: " + script + " " + StringUtils.join(args, (String)" ");
        logger.info(loggerMessage);
        ExecExternalProcess proc = new ExecExternalProcess();
        int exitValue = proc.execExternalProcess(script, args);
        if (exitValue == 0) {
            logger.info("Execution ended successfully");
            return proc.getInputStream();
        }
        String output = StringUtils.isNotBlank((String)proc.getErrorStream()) ? proc.getErrorStream() : proc.getInputStream();
        logger.error("Execution failed , STDERR : " + output, new String[0]);
        throw new ScriptException("Execute the program failed - exit value = " + exitValue + " Output: " + output);
    }
}

