/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.procauto;

import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.annotation.emailData;
import com.exlibris.repository.procauto.HPaProcess;
import com.exlibris.repository.procauto.HPaProcessExecutionBulk;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@NamedQueries(value={@NamedQuery(name="findSingleProcessExecution", query="SELECT hpe from HPaProcessExecution as hpe WHERE hpe.status=:status AND ROWNUM<:rowtofetch"), @NamedQuery(name="getLastRunDate", query="SELECT max(finishDate) from HPaProcessExecution WHERE process=:process"), @NamedQuery(name="getProcessExecutionByProcess", query="SELECT hpe from HPaProcessExecution as hpe WHERE process=:process"), @NamedQuery(name="getNotCompletedExecutions", query="SELECT hpe from HPaProcessExecution as hpe WHERE process=:process and status in (:status1, :status2, :status3)"), @NamedQuery(name="getExecById", query="from HPaProcessExecution hpe where hpe.processExecutionId = :id"), @NamedQuery(name="getOldProcessExecutions", query="select processExecutionId from HPaProcessExecution where  (creationDate <  :date and status between 2 and 6) or process  in (select processId  from HPaProcess where status = 2)")})
@javax.persistence.Table(name="HPAPROCESSEXECUTION")
@Table(appliesTo="HPAPROCESSEXECUTION", indexes={@Index(name="HPAPROCESSEXECUTION_ID_STATUS", columnNames={"PROCESS_ID", "STATUS"})})
public class HPaProcessExecution {
    public static final String GET_NOT_COMPLETED_EXECUTIONS = "getNotCompletedExecutions";
    public static final String GET_EXEC_BY_ID = "getExecById";
    private Long processExecutionId;
    private HPaProcess process;
    private String name;
    private ProcessExecutionStatus status;
    private Long setId;
    private String createdBy;
    private Date creationDate;
    private Date statusDate;
    private Date startDate;
    private Date finishDate;
    private String indexXml;
    private Integer progress;
    private String timeEstimation;
    private String failureNote;
    private Long priority;
    private List<HPaProcessExecutionBulk> processExecutionBulks;

    @Id
    @emailData
    @Column(name="PROCESS_EXECUTION_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Searchable
    public Long getProcessExecutionId() {
        return this.processExecutionId;
    }

    public void setProcessExecutionId(Long processExecutionId) {
        this.processExecutionId = processExecutionId;
    }

    @ManyToOne
    @JoinColumn(name="PROCESS_ID", referencedColumnName="PROCESS_ID", nullable=false)
    @Index(name="HPAPROCESSEXECUTION_PROCESS")
    public HPaProcess getProcess() {
        return this.process;
    }

    public void setProcess(HPaProcess process) {
        this.process = process;
    }

    @Searchable
    @emailData
    @Column(name="NAME", nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(mappedBy="processExecution")
    public List<HPaProcessExecutionBulk> getProcessExecutionBulks() {
        return this.processExecutionBulks;
    }

    public void setProcessExecutionBulks(List<HPaProcessExecutionBulk> processExecutionBulks) {
        this.processExecutionBulks = processExecutionBulks;
    }

    @emailData
    @Column(name="SET_ID")
    public Long getSetId() {
        return this.setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }

    @Searchable
    @emailData
    @Column(name="CREATED_BY", nullable=false)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Column(name="CREATION_DATE", nullable=false)
    @emailData
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Searchable
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    @Index(name="HPAPROCESSEXECUTION_STATUS")
    @emailData
    public ProcessExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessExecutionStatus newStatus) {
        this.status = newStatus;
    }

    @Column(name="STATUS_DATE", nullable=false)
    @emailData
    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    @Column(name="START_DATE", nullable=false)
    @Searchable
    @emailData
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Column(name="FINISH_DATE")
    @Searchable
    @emailData
    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    @Column(name="FAILURE_NOTE")
    public String getFailureNote() {
        return this.failureNote;
    }

    public void setFailureNote(String failureNote) {
        this.failureNote = failureNote;
    }

    @Column(name="PRIORITY")
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Lob
    @Column(name="index_xml")
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    @Transient
    public Integer getProgress() {
        return this.progress;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    @Transient
    @emailData
    public String getTimeEstimation() {
        return this.timeEstimation;
    }

    public void setTimeEstimation(String timeEstimation) {
        this.timeEstimation = timeEstimation;
    }

    @Transient
    @Searchable
    public String getTaskChain() {
        if (this.getProcess() != null && this.getProcess().getTaskChain() != null) {
            return this.getProcess().getTaskChain().getName();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.processExecutionId == null ? 0 : this.processExecutionId.hashCode());
        result = 31 * result + (this.setId == null ? 0 : this.setId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPaProcessExecution)) {
            return false;
        }
        HPaProcessExecution other = (HPaProcessExecution)obj;
        if (this.processExecutionId == null ? other.processExecutionId != null : !this.processExecutionId.equals(other.processExecutionId)) {
            return false;
        }
        return !(this.setId == null ? other.setId != null : !this.setId.equals(other.setId));
    }

    public void changeStatus(ProcessExecutionStatus status) {
        this.setStatus(status);
        Date now = new Date();
        this.setStatusDate(now);
        if (ProcessExecutionStatus.RUNNING.equals((Object)status)) {
            this.setStartDate(now);
        }
        if (ProcessExecutionStatus.USER_ABORTED.equals((Object)status) || ProcessExecutionStatus.SYSTEM_ABORTED.equals((Object)status) || ProcessExecutionStatus.COMPLETED_SUCCESS.equals((Object)status) || ProcessExecutionStatus.COMPLETED_NO_BULKS.equals((Object)status) || ProcessExecutionStatus.COMPLETED_FAILED.equals((Object)status)) {
            this.setFinishDate(now);
        }
    }

    public static enum ProcessExecutionStatus {
        PENDING,
        RUNNING,
        USER_ABORTED,
        SYSTEM_ABORTED,
        COMPLETED_SUCCESS,
        COMPLETED_NO_BULKS,
        COMPLETED_FAILED,
        INITIALIZING,
        WAITING,
        ABORTING;

    }
}

