/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.console;

import com.exlibris.core.infra.console.ConsolePage;
import com.exlibris.core.infra.svc.api.sharedsession.SessionHelper;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SessionContent
extends ConsolePage {
    private void addObj(Set<Object> objs, StringBuilder sb, String name, Object object, String context) {
        String objectStr = object.toString();
        if (objectStr.length() > 200) {
            sb.append("<tr title=\"" + objectStr.replace("\"", "&quot;") + "\">");
        } else {
            sb.append("<tr>");
        }
        this.addColumn(sb, name);
        if (objectStr.length() > 200) {
            this.addColumn(sb, objectStr.substring(0, 200) + "...");
        } else {
            this.addColumn(sb, objectStr);
        }
        this.addColumn(sb, context);
        sb.append("</tr>");
    }

    String printSessionContent(String sessionId) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (SessionHelper.getSharedSessions().get(sessionId) != null) {
            HashSet<Object> objs = new HashSet<Object>();
            SessionHelper.SharedSession sharedSession = (SessionHelper.SharedSession)SessionHelper.getSharedSessions().get(sessionId).get();
            this.addHeader(sb);
            sb.append("<table border='1'>");
            sb.append("<tr>");
            this.addColumn(sb, "name");
            this.addColumn(sb, "value");
            this.addColumn(sb, "context");
            sb.append("</tr>");
            for (String name : sharedSession.attributes.keySet()) {
                this.addObj(objs, sb, name, sharedSession.attributes.get(name), "SHARED");
            }
            for (String context : sharedSession.sessionContexts) {
                HttpSession session = sharedSession.sessions.get(context);
                Enumeration names = session.getAttributeNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    this.addObj(objs, sb, name, session.getAttribute(name), context);
                }
            }
            sb.append("</table>");
            this.addFooter(sb);
        }
        return sb.toString();
    }
}

