/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uk.gov.nationalarchives.droid.container.ContainerFile;
import uk.gov.nationalarchives.droid.container.ContainerSignature;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignatureCollection;

public class ContainerSignatureMatch {
    private ContainerSignature signature;
    private long maxBytesToScan = -1L;
    private Set<String> unmatchedFiles = new HashSet<String>();

    public ContainerSignatureMatch(ContainerSignature sig, long maxBytesToScan) {
        this.unmatchedFiles.addAll(sig.getFiles().keySet());
        this.signature = sig;
        this.maxBytesToScan = maxBytesToScan;
    }

    public Set<String> getUnmatchedFiles() {
        return this.unmatchedFiles;
    }

    public boolean isMatch() {
        return this.unmatchedFiles.isEmpty();
    }

    public void matchFileEntry(String entryName) {
        InternalSignatureCollection binSigs;
        if (this.unmatchedFiles.contains(entryName) && (binSigs = this.signature.getFiles().get(entryName).getCompiledBinarySignatures()) == null) {
            this.unmatchedFiles.remove(entryName);
        }
    }

    public boolean needsBinaryMatch(String entryName) {
        boolean needsMatch = false;
        if (this.unmatchedFiles.contains(entryName)) {
            InternalSignatureCollection binarySigs = this.signature.getFiles().get(entryName).getCompiledBinarySignatures();
            needsMatch = binarySigs != null;
        }
        return needsMatch;
    }

    public void matchBinaryContent(String entryName, ByteReader content) {
        boolean matched = true;
        if (this.unmatchedFiles.contains(entryName)) {
            Map<String, ContainerFile> sigFiles = this.signature.getFiles();
            InternalSignatureCollection binSigs = sigFiles.get(entryName).getCompiledBinarySignatures();
            if (binSigs != null) {
                boolean bl = matched = binSigs.getMatchingSignatures(content, this.maxBytesToScan).size() > 0;
            }
            if (matched) {
                this.unmatchedFiles.remove(entryName);
            }
        }
    }

    public ContainerSignature getSignature() {
        return this.signature;
    }
}

