/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.codetables;

import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.codetables.HCodeColumnNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@NamedQueries(value={@NamedQuery(name="findAllTablesOfType", query="from HTableOfTables where tableType = :tableType order by upper(displayTableName) ASC"), @NamedQuery(name="findTablesOfTypeForSubSystem", query="from HTableOfTables where tableType = :tableType and subSystem = :subsystem order by upper(displayTableName) ASC "), @NamedQuery(name="findTablesForSubSystem", query="from HTableOfTables where subSystem = :subsystem order by upper(displayTableName) ASC "), @NamedQuery(name="findTablesByLevel", query="from HTableOfTables where tableLevel in(:levels) order by upper(displayTableName) ASC"), @NamedQuery(name="findTablesByTypeAndLevel", query="from HTableOfTables where tableType = :tableType and tableLevel in(:levels) order by upper(displayTableName) ASC"), @NamedQuery(name="findTablesByPolicy", query="from HTableOfTables where spPolicy in (:spPolicy) order by upper(codeTableName) ASC "), @NamedQuery(name="findTablesBySubSystemAndCustomerBehavior", query="from HTableOfTables where tableType = :tableType and subSystem = :subSystem and customerBehavior in (:costumerBehaviors)")})
@Table(name="C_C_TABLE_OF_TABLES")
public class HTableOfTables
extends HOwneredEntity {
    public static final String INITIAL_LEVEL = "I";
    public static final String ONGOING_LEVEL = "G";
    public static final String ADVANCED_LEVEL = "A";
    public static final String ALL_LEVEL = "ALL";
    public static final String INITIAL_LM = "I";
    public static final String INITIAL_ADVANCED_LM = "IA";
    public static final String ONGOING_LM = "O";
    public static final String ALL_LM = "ALL";
    public static final String CODE_TYPE = "C";
    public static final String MAPPING_TYPE = "M";
    public static final String ORG_LEVEL_INSTITUTION = "INS";
    public static final String ORG_LEVEL_CONSORTIA = "CRS";
    public static final String SP_POLICY_OVERRIDDEN = "OVERRIDDEN";
    public static final String SP_POLICY_NOT_OVERRIDDEN = "NOT_OVERRIDDEN";
    public static final String SP_POLICY_MERGED = "MERGED";
    public static final String CUSTOMER_BEHAVIOR_FIXED = "FIXED_ROWS";
    public static final String CUSTOMER_BEHAVIOR_ALL = "ALL";
    public static final String CUSTOMER_BEHAVIOR_HIDE = "HIDE";
    public static final String DEINHERIT_TYPE_TABLE = "TABLE";
    public static final String DEINHERIT_TYPE_ROW = "ROW";
    private String subSystem;
    private String codeTableName;
    private String displayTableName;
    private String tableLevel;
    private String tableType;
    private String description;
    private boolean enabled;
    private String organizationalLevel = "CRS";
    private Set<HCodeColumnNames> codeColumnNamesSet = new HashSet<HCodeColumnNames>(0);
    private List<HCodeColumnNames> orderedList = new ArrayList<HCodeColumnNames>();
    private List<HCodeColumnNames> orderedTargetLastList = new ArrayList<HCodeColumnNames>();
    private String customerBehavior = "ALL";
    private String spPolicy;
    private String deInheritType;
    private String lowestDeInheritLevel;
    private String otbPolicy;

    public HTableOfTables() {
    }

    public HTableOfTables(String subSystem, String codeTableName, String displayTableName, String tableLevel, String tableType, String customerBehavior, String spPolicy) {
        this.subSystem = subSystem;
        this.codeTableName = codeTableName;
        this.displayTableName = displayTableName;
        this.tableLevel = tableLevel;
        this.tableType = tableType;
        this.customerBehavior = customerBehavior;
        this.spPolicy = spPolicy;
    }

    public HTableOfTables(String subSystem, String codeTableName, String displayTableName, String tableLevel, String tableType, String description, boolean enabled, Set<HCodeColumnNames> codeColumnNamesSet, String customerBehavior, String spPolicy) {
        this.subSystem = subSystem;
        this.codeTableName = codeTableName;
        this.displayTableName = displayTableName;
        this.tableLevel = tableLevel;
        this.tableType = tableType;
        this.description = description;
        this.enabled = enabled;
        this.codeColumnNamesSet = codeColumnNamesSet;
        this.customerBehavior = customerBehavior;
        this.spPolicy = spPolicy;
    }

    @Column(name="SUB_SYSTEM", nullable=false, length=50)
    public String getSubSystem() {
        return this.subSystem;
    }

    public void setSubSystem(String subSystem) {
        this.subSystem = subSystem;
    }

    @Column(name="CODE_TABLE_NAME", unique=true, nullable=false, length=50)
    public String getCodeTableName() {
        return this.codeTableName;
    }

    public void setCodeTableName(String codeTableName) {
        this.codeTableName = codeTableName;
    }

    @Column(name="DISPLAY_TABLE_NAME", nullable=false, length=50)
    public String getDisplayTableName() {
        return this.displayTableName;
    }

    public void setDisplayTableName(String displayTableName) {
        this.displayTableName = displayTableName;
    }

    @Column(name="TABLE_LEVEL", nullable=false, length=3)
    public String getTableLevel() {
        return this.tableLevel;
    }

    public void setTableLevel(String tableLevel) {
        this.tableLevel = tableLevel;
    }

    @Column(name="TABLE_TYPE", nullable=false, length=2)
    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    @Column(name="description", length=4000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="ENABLED")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="tableOfTables")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<HCodeColumnNames> getCodeColumnNamesSet() {
        return this.codeColumnNamesSet;
    }

    public void setCodeColumnNamesSet(Set<HCodeColumnNames> codeColumnNamesSet) {
        this.codeColumnNamesSet = codeColumnNamesSet;
    }

    public void addCodeColumnNames(HCodeColumnNames codeColumnNames) {
        this.codeColumnNamesSet.add(codeColumnNames);
        codeColumnNames.setTableOfTables(this);
    }

    @Transient
    public List<HCodeColumnNames> getOrderedCodeColumnNames() {
        this.orderedList.clear();
        this.orderedList.addAll(this.getCodeColumnNamesSet());
        Collections.sort(this.orderedList);
        return this.orderedList;
    }

    @Transient
    public List<HCodeColumnNames> getOrderedColumnNamesTargetLast() {
        this.orderedTargetLastList.clear();
        this.orderedTargetLastList.addAll(this.getOrderedCodeColumnNames());
        if (this.orderedTargetLastList.size() > 1) {
            HCodeColumnNames targetColumn = this.orderedTargetLastList.get(0);
            this.orderedTargetLastList.remove(0);
            this.orderedTargetLastList.add(targetColumn);
        }
        return this.orderedTargetLastList;
    }

    @Column(name="CUSTOMER_BEHAVIOR", nullable=false, length=50)
    public String getCustomerBehavior() {
        return this.customerBehavior;
    }

    public void setCustomerBehavior(String customerBehavior) {
        this.customerBehavior = customerBehavior;
    }

    @Column(name="SP_POLICY", nullable=false, length=50)
    public String getSpPolicy() {
        return this.spPolicy;
    }

    public void setSpPolicy(String spPolicy) {
        this.spPolicy = spPolicy;
    }

    @Column(name="DEINHERIT_TYPE", nullable=true, length=50)
    public String getDeInheritType() {
        return this.deInheritType;
    }

    public void setDeInheritType(String deInheritType) {
        this.deInheritType = deInheritType;
    }

    @Column(name="LOWEST_DEINHERIT_LEVEL", nullable=true, length=50)
    public String getLowestDeInheritLevel() {
        return this.lowestDeInheritLevel;
    }

    public void setLowestDeInheritLevel(String lowestDeInheritLevel) {
        this.lowestDeInheritLevel = lowestDeInheritLevel;
    }

    @Column(name="OTB_POLICY", nullable=true, length=50)
    public String getOtbPolicy() {
        return this.otbPolicy;
    }

    public void setOtbPolicy(String otbPolicy) {
        this.otbPolicy = otbPolicy;
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + (this.codeTableName == null ? 0 : this.codeTableName.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HTableOfTables)) {
            return false;
        }
        HTableOfTables other = (HTableOfTables)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        if (this.codeTableName == null ? other.codeTableName != null : !this.codeTableName.equals(other.codeTableName)) {
            return false;
        }
        if (this.customerBehavior == null ? other.customerBehavior != null : !this.customerBehavior.equals(other.customerBehavior)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayTableName == null ? other.displayTableName != null : !this.displayTableName.equals(other.displayTableName)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.spPolicy == null ? other.spPolicy != null : !this.spPolicy.equals(other.spPolicy)) {
            return false;
        }
        if (this.subSystem == null ? other.subSystem != null : !this.subSystem.equals(other.subSystem)) {
            return false;
        }
        if (this.tableLevel == null ? other.tableLevel != null : !this.tableLevel.equals(other.tableLevel)) {
            return false;
        }
        return !(this.tableType == null ? other.tableType != null : !this.tableType.equals(other.tableType));
    }

    @Override
    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        HTableOfTables other = (HTableOfTables)o;
        return this.codeTableName.compareTo(other.codeTableName);
    }

    @Column(name="ORG_LEVEL", length=3)
    public String getOrganizationalLevel() {
        return this.organizationalLevel;
    }

    public void setOrganizationalLevel(String organizationalLevel) {
        this.organizationalLevel = organizationalLevel;
    }
}

