/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.delivery;

import com.exlibris.repository.persistence.HPersistent;
import com.exlibris.repository.persistence.delivery.DeliveryRule;
import com.exlibris.repository.persistence.delivery.DeliveryViewer;
import com.exlibris.repository.persistence.delivery.RepresentationProfile;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;

@Entity
@Table(name="DELRULEOUTPUTPARAM")
@NamedQueries(value={@NamedQuery(name="viewerInUse", query="select count(id) from DelRuleOutputParam where deliveryviewerid =:viewerId")})
public class DelRuleOutputParam
extends HPersistent {
    private static final long serialVersionUID = 1L;
    public static final String MULTIPLE_SEPARATOR_IN_DB = ",";
    private RepresentationProfile representationProfile;
    private DeliveryViewer viewer;
    private Long representationProfileId;
    private Long viewerId;
    private String parameters;
    private boolean embedded;
    private boolean toolbar;
    private Integer ruleParamOrder;
    private DeliveryRule deliveryRule;
    private String indexXml;

    @ManyToOne
    @JoinColumn(name="REPRESENTATIONPROFILEID", nullable=true)
    @Index(name="REPRESENTATIONPROFILE_ID_IDX")
    public RepresentationProfile getRepresentationProfile() {
        return this.representationProfile;
    }

    public void setRepresentationProfile(RepresentationProfile representationProfile) {
        this.representationProfile = representationProfile;
    }

    @ManyToOne
    @JoinColumn(name="DELIVERYVIEWERID", nullable=false)
    @Index(name="DELIVERYVIEWER_ID_IDX")
    public DeliveryViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(DeliveryViewer viewer) {
        this.viewer = viewer;
    }

    @Transient
    public Long getRepresentationProfileId() {
        return this.representationProfileId;
    }

    public void setRepresentationProfileId(Long representationProfileId) {
        this.representationProfileId = representationProfileId;
    }

    @Transient
    public Long getViewerId() {
        return this.viewerId;
    }

    public void setViewerId(Long viewerId) {
        this.viewerId = viewerId;
    }

    @Column(name="PARAMETERS")
    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    @Column(name="EMBEDDED")
    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    @Column(name="TOOLBAR")
    public boolean isToolbar() {
        return this.toolbar;
    }

    public void setToolbar(boolean toolbar) {
        this.toolbar = toolbar;
    }

    @Transient
    public String[] getParametersArray() {
        return this.convertStringToArray(this.parameters);
    }

    @Transient
    public Map<String, Object> getParametersMap() {
        return this.convertStringToMap(this.parameters);
    }

    public void setParametersArray(String[] parametersArray) {
        this.parameters = this.convertArrayToString(parametersArray);
    }

    public Integer getRuleParamOrder() {
        return this.ruleParamOrder;
    }

    public void setRuleParamOrder(Integer ruleParamOrder) {
        this.ruleParamOrder = ruleParamOrder;
    }

    @ManyToOne(targetEntity=DeliveryRule.class, optional=false)
    @Index(name="DELIVERYRULEID_IDX")
    public DeliveryRule getDeliveryRule() {
        return this.deliveryRule;
    }

    public void setDeliveryRule(DeliveryRule deliveryRule) {
        this.deliveryRule = deliveryRule;
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public void synchronizeIdsWithObjects() {
        if (this.representationProfile != null) {
            this.setRepresentationProfileId(this.representationProfile.getId());
        }
        if (this.viewer != null) {
            this.setViewerId(this.viewer.getId());
        }
    }

    private Map<String, Object> convertStringToMap(String parameters) {
        String[] parameterArray;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (parameters == null || parameters.trim().length() == 0) {
            return paramMap;
        }
        for (String parameter : parameterArray = this.convertStringToArray(parameters)) {
            paramMap.put(parameter.split("=")[0].toLowerCase(), parameter.split("=")[1].toLowerCase());
        }
        return paramMap;
    }

    public class OrderComparator
    implements Comparator {
        public int compare(Object param1, Object param2) {
            Integer order1 = ((DelRuleOutputParam)param1).getRuleParamOrder();
            Integer order2 = ((DelRuleOutputParam)param2).getRuleParamOrder();
            return order1.compareTo(order2);
        }
    }
}

