/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Action;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;

public class SignificantItemDetector
extends ProxyReceiver {
    private int level = 0;
    private boolean empty = true;
    private Action trigger;

    public SignificantItemDetector(Receiver next, Action trigger) {
        super(next);
        this.trigger = trigger;
    }

    private void start() throws XPathException {
        if (this.empty) {
            this.trigger.doAction();
            this.empty = false;
        }
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.level++ != 0) {
            super.startDocument(properties);
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.start();
        ++this.level;
        super.startElement(elemName, typeCode, location, properties);
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        this.start();
        super.namespace(namespaceBindings, properties);
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        this.start();
        super.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (chars.length() > 0) {
            this.start();
        }
        super.characters(chars, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        this.start();
        super.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.start();
        super.comment(chars, locationId, properties);
    }

    public static boolean isSignificant(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            return !(node.getNodeKind() == 3 && node.getStringValue().isEmpty() || node.getNodeKind() == 9 && !node.hasChildNodes());
        }
        if (item instanceof AtomicValue) {
            return !item.getStringValue().isEmpty();
        }
        if (item instanceof ArrayItem) {
            if (((ArrayItem)item).isEmpty()) {
                return true;
            }
            for (Sequence sequence : ((ArrayItem)item).members()) {
                try {
                    Object it;
                    SequenceIterator memIter = sequence.iterate();
                    while ((it = memIter.next()) != null) {
                        if (!SignificantItemDetector.isSignificant(it)) continue;
                        return true;
                    }
                }
                catch (XPathException e) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (SignificantItemDetector.isSignificant(item)) {
            this.start();
        }
        super.append(item, locationId, copyNamespaces);
    }

    @Override
    public void endDocument() throws XPathException {
        if (--this.level != 0) {
            super.endDocument();
        }
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        super.endElement();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

