/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class KeyValueReader {
    private static final Logger logger = LoggerFactory.getLogger(KeyValueReader.class);
    private static final String INDENTED_LINE_REGEX = "^\\s+.*";
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private KeyValueReader() {
    }

    public static List<AbstractMap.SimpleImmutableEntry<String, String>> readKeyValuesFromFile(Path file, String splitRegex, Charset charset) throws IOException, InvalidBagMetadataException {
        ArrayList<AbstractMap.SimpleImmutableEntry<String, String>> keyValues = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>();
        try (BufferedReader reader = Files.newBufferedReader(file, charset);){
            String line = reader.readLine();
            while (line != null) {
                if (line.matches(INDENTED_LINE_REGEX) && !keyValues.isEmpty()) {
                    KeyValueReader.mergeIndentedLine(line, keyValues);
                } else {
                    String[] parts = KeyValueReader.checkLineFormat(line, splitRegex);
                    String key = parts[0].trim();
                    String value = parts[1].trim();
                    logger.debug(messages.getString("read_key_value_line"), new Object[]{key, value, file, splitRegex});
                    keyValues.add(new AbstractMap.SimpleImmutableEntry<String, String>(key, value));
                }
                line = reader.readLine();
            }
        }
        return keyValues;
    }

    private static void mergeIndentedLine(String line, List<AbstractMap.SimpleImmutableEntry<String, String>> keyValues) {
        AbstractMap.SimpleImmutableEntry<String, String> oldKeyValue = keyValues.remove(keyValues.size() - 1);
        AbstractMap.SimpleImmutableEntry<String, String> newKeyValue = new AbstractMap.SimpleImmutableEntry<String, String>(oldKeyValue.getKey(), oldKeyValue.getValue() + System.lineSeparator() + line);
        keyValues.add(newKeyValue);
        logger.debug(messages.getString("found_indented_line"), (Object)oldKeyValue.getKey());
    }

    private static String[] checkLineFormat(String line, String splitRegex) throws InvalidBagMetadataException {
        String[] parts = line.split(splitRegex, 2);
        if (parts.length != 2) {
            String formattedMessage = messages.getString("malformed_key_value_line_error");
            throw new InvalidBagMetadataException(MessageFormatter.format((String)formattedMessage, (Object)line, (Object)splitRegex).getMessage());
        }
        return parts;
    }
}

