/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.attachments.HFrAttachments;
import com.exlibris.core.infra.svc.api.VirusCheckMessageData;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;

public class VirusCheckClient {
    private static final ExLogger logger = ExLogger.getExLogger(VirusCheckClient.class);
    private static QueueConnection cnn = null;
    private static QueueSender sender = null;
    private static Queue queueRequest = null;
    private static Queue queueResponse = null;

    private static void init() {
        try {
            if (cnn == null || sender == null || queueRequest == null) {
                InitialContext ctx = new InitialContext();
                queueRequest = (Queue)ctx.lookup("queue/viruscheckRequest");
                queueResponse = (Queue)ctx.lookup("queue/viruscheckResponse");
                QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("ConnectionFactory");
                cnn = factory.createQueueConnection();
            }
        }
        catch (Exception e) {
            logger.error("JMSClient" + e.getStackTrace(), new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String virusCheckScript, String correlationId, HFrAttachments attachment, String userPrincipal) {
        QueueSession sess = null;
        VirusCheckMessageData messageData = new VirusCheckMessageData();
        messageData.setVirusCheckScript(virusCheckScript);
        messageData.setAttachment(attachment);
        messageData.setUserPrincipal(userPrincipal);
        try {
            VirusCheckClient.init();
            sess = cnn.createQueueSession(false, 1);
            ObjectMessage msg = sess.createObjectMessage((Serializable)messageData);
            msg.setJMSCorrelationID(correlationId);
            msg.setJMSReplyTo((Destination)queueResponse);
            sender = sess.createSender(queueRequest);
            sender.send((Message)msg);
        }
        catch (JMSException e) {
            logger.error(e);
        }
        finally {
            try {
                sess.close();
            }
            catch (JMSException e) {
                logger.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isComplete(String correlationId) {
        boolean complete = false;
        QueueSession sess = null;
        Object receivedMsg = null;
        try {
            VirusCheckClient.init();
            sess = cnn.createQueueSession(false, 1);
            QueueBrowser queueBrowser = sess.createBrowser(queueResponse);
            Enumeration e = queueBrowser.getEnumeration();
            while (e.hasMoreElements()) {
                Message message = (Message)e.nextElement();
                if (!correlationId.equals(message.getJMSCorrelationID())) continue;
                complete = true;
            }
        }
        catch (JMSException e) {
            logger.error(e);
        }
        finally {
            try {
                sess.close();
            }
            catch (JMSException e) {
                logger.error(e);
            }
        }
        return complete;
    }
}

