/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.rules.HFrRule;
import com.exlibris.core.infra.model.rules.HFrRuleParam;
import com.exlibris.core.infra.svc.api.RulesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DnxRuleBridge {
    private static ExLogger log = ExLogger.getExLogger(DnxRuleBridge.class);

    public static List<HFrRuleParam> runRuleEngine(String ruleType, DnxDocument ... docs) {
        RulesManager rulesManager = (RulesManager)ServiceLocator.getInstance().lookUp(RulesManager.class);
        HFrRule defaultRule = rulesManager.getDefaultRuleForAllInstitution(ruleType);
        List<HFrRule> rules = rulesManager.getRulesByTypeForAllInstitution(ruleType);
        for (HFrRule rule : rules) {
            List<HFrRuleParam> params = rule.getRuleParamsBySection("DNX");
            Map<String, List<String>> values = DnxRuleBridge.extractParamsFromDnx(params, docs);
            if (!rulesManager.isRuleMatchesMultiValues(rule, values, "DNX")) continue;
            return rule.getRuleParamsBySection("OUT");
        }
        if (defaultRule != null) {
            return defaultRule.getRuleParamsBySection("OUT");
        }
        return null;
    }

    private static Map<String, List<String>> extractParamsFromDnx(List<HFrRuleParam> ruleParams, DnxDocument[] docs) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (DnxDocument doc : docs) {
            for (HFrRuleParam param : ruleParams) {
                DnxSection dnxSec = doc.getSectionById(param.getDnxSection());
                if (dnxSec == null) continue;
                String value = dnxSec.getSectionKeyValue(param.getDnxSectionKey());
                if (ret.get(param.getKey()) == null) {
                    ret.put(param.getKey(), new ArrayList());
                }
                ((List)ret.get(param.getKey())).add(value);
            }
        }
        return ret;
    }
}

