/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.ech0160v11;

import bsh.EvalError;
import ch.admin.bar.arelda.v4.AblieferungFilesSIP;
import ch.admin.bar.arelda.v4.AblieferungGeverSIP;
import ch.admin.bar.arelda.v4.AblieferungSIP;
import ch.admin.bar.arelda.v4.DateiSIP;
import ch.admin.bar.arelda.v4.Dokument;
import ch.admin.bar.arelda.v4.DokumentFilesSIP;
import ch.admin.bar.arelda.v4.DokumentGeverSIP;
import ch.admin.bar.arelda.v4.DossierFilesSIP;
import ch.admin.bar.arelda.v4.DossierGeverSIP;
import ch.admin.bar.arelda.v4.EigenschaftDatei;
import ch.admin.bar.arelda.v4.HistorischerZeitpunkt;
import ch.admin.bar.arelda.v4.HistorischerZeitraum;
import ch.admin.bar.arelda.v4.OrdnerSIP;
import ch.admin.bar.arelda.v4.OrdnungssystemFilesSIP;
import ch.admin.bar.arelda.v4.OrdnungssystemGeverSIP;
import ch.admin.bar.arelda.v4.OrdnungssystempositionFilesSIP;
import ch.admin.bar.arelda.v4.OrdnungssystempositionGeverSIP;
import ch.admin.bar.arelda.v4.PaketSIP;
import ch.admin.bar.arelda.v4.PaketTyp;
import ch.admin.bar.arelda.v4.ProvenienzFilesSIP;
import ch.admin.bar.arelda.v4.ProvenienzGeverSIP;
import ch.admin.bar.arelda.v4.Pruefalgorithmus;
import ch.admin.bar.arelda.v4.ZusatzDaten;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementCantAddException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.LevelOfDescriptionSet;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.mapping.ech0160v11.ExportException;
import ch.docuteam.mapping.ech0160v11.FieldType;
import ch.docuteam.mapping.ech0160v11.IncompatibleMappingAndLevelsException;
import ch.docuteam.mapping.ech0160v11.InvalidMappingException;
import ch.docuteam.mapping.ech0160v11.InvalidSIPException;
import ch.docuteam.mapping.ech0160v11.LevelType;
import ch.docuteam.mapping.ech0160v11.LevelsNotFoundException;
import ch.docuteam.mapping.ech0160v11.MappingAdapter;
import ch.docuteam.mapping.ech0160v11.MessageDigestException;
import ch.docuteam.mapping.ech0160v11.UnhandledEchValueTypeException;
import ch.docuteam.tools.file.FileChecksumCalculator;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.Zipper;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SIPExporter {
    private static final String VALUE_DELIMITER = ": ";
    private static final String CONTEXT_PATH_BAR_ARELDA = "ch.admin.bar.arelda.v4";
    private static final String TMP_DIR_PREFIX = "ech0160v11";
    private static final String HEADER_FOLDER = "header";
    private static final String CONTENT_FOLDER = "content";
    private static final String METADATA_FILE_NAME = "metadata.xml";
    static final String LABEL_ABLIEFERUNG = "Ablieferung";
    static final String LABEL_PROVENIENZ = "Provenienz";
    static final String LABEL_ORDNUNGSSYSTEM = "Ordnungssystem";
    static final String INCLUDE_METADATA_FILE = "file";
    private static final String UNIT_TITLE = "unitTitle";
    private static Map<Pruefalgorithmus, FileChecksumCalculator.Algorithm> algorithmMap = new HashMap<Pruefalgorithmus, FileChecksumCalculator.Algorithm>();
    private Path tempFolderPath;
    private Path sourceSIPPath;
    private Document metsDocument;
    private LevelOfDescriptionSet metsLevels;
    private PaketSIP packageSIP;
    private Map<String, ContentFile> idToContentFileMap;
    private List<List<String>> listOfListOfIds = new ArrayList<List<String>>();
    private Set<String> notEmptyElementsIds = new HashSet<String>();
    private final String operatorName;
    private MappingAdapter mappingAdapter;
    private Map<MappingAdapter.ECH_LEVELS, LevelType> mappedLevels;

    public SIPExporter(String operatorName, MappingAdapter mappingAdapter, String levelsConfigPath) throws LevelsNotFoundException {
        this.operatorName = operatorName;
        this.mappingAdapter = mappingAdapter;
        this.mappedLevels = mappingAdapter.getMappedLevels();
        if (!LevelOfDescription.isInitializationFileFound((String)levelsConfigPath)) {
            throw new LevelsNotFoundException(levelsConfigPath);
        }
        LevelOfDescription.setInitializationFilePath((String)levelsConfigPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path exportECH0160ToMETS(Path eCH0160SipPath, Path targetPath) throws InvalidMappingException, IOException, InvalidSIPException, ExportException, IncompatibleMappingAndLevelsException, FileAlreadyExistsException, UnhandledEchValueTypeException {
        this.sourceSIPPath = this.unzip(eCH0160SipPath);
        String sipNameWithoutExtension = FileUtil.asFileNameWithoutExtension((File)eCH0160SipPath.toFile());
        try {
            this.packageSIP = SIPExporter.unmarshallPackageSIP(this.sourceSIPPath);
            this.idToContentFileMap = this.getContentFiles(this.packageSIP, this.sourceSIPPath);
            Path path = this.generateMetsSIP(this.packageSIP, this.sourceSIPPath, sipNameWithoutExtension, targetPath);
            return path;
        }
        finally {
            this.cleanUp();
        }
    }

    Map<String, ContentFile> getContentFiles(PaketSIP packageSIP, Path parentPath) {
        HashMap<String, ContentFile> collectorMap = new HashMap<String, ContentFile>();
        List<OrdnerSIP> ordnerList = packageSIP.getInhaltsverzeichnis().getOrdner();
        List contentFolderList = ordnerList.stream().filter(ordner -> ordner.getName().equals(CONTENT_FOLDER)).collect(Collectors.toList());
        if (contentFolderList.size() == 1) {
            this.getAllContentFilesRecursive((OrdnerSIP)contentFolderList.get(0), parentPath.resolve(((OrdnerSIP)contentFolderList.get(0)).getName()), collectorMap);
        }
        return collectorMap;
    }

    private void getAllContentFilesRecursive(OrdnerSIP ordnerSIP, Path parentPath, Map<String, ContentFile> collectorMap) {
        List<DateiSIP> dateiList = ordnerSIP.getDatei();
        Map<String, ContentFile> contentFileMap = dateiList.stream().collect(Collectors.toMap(datei -> datei.getId(), datei -> new ContentFile((DateiSIP)datei, parentPath)));
        collectorMap.putAll(contentFileMap);
        List<OrdnerSIP> ordnerList = ordnerSIP.getOrdner();
        for (OrdnerSIP ordner : ordnerList) {
            this.getAllContentFilesRecursive(ordner, parentPath.resolve(ordner.getName()), collectorMap);
        }
    }

    private Path generateMetsSIP(PaketSIP packageSIP, Path eCH0160SipPath, String sipNameWithoutExtension, Path targetPath) throws ExportException, IncompatibleMappingAndLevelsException, UnhandledEchValueTypeException, FileAlreadyExistsException {
        try {
            Path metsSIPPath;
            java.lang.Object sipName = sipNameWithoutExtension;
            if (!this.mappingAdapter.isOutputSIPUnzipped()) {
                sipName = (String)sipName + ".zip";
            }
            if ((metsSIPPath = targetPath.resolve((String)sipName)).toFile().exists()) {
                throw new FileAlreadyExistsException((String)sipName, metsSIPPath.getParent().toString());
            }
            Logger.debug((java.lang.Object)("metsSIPPath: " + metsSIPPath));
            this.metsDocument = Document.createNewWithRootFolderName((String)metsSIPPath.toString(), (String)sipNameWithoutExtension, (String)this.mappingAdapter.getSaId(), (String)this.mappingAdapter.getDssId(), (String)this.operatorName);
            NodeAbstract targetRootNode = this.metsDocument.getStructureMap().getRoot();
            this.metsLevels = this.metsDocument.getLevels();
            this.validateMappingAgainstMetsLevels(this.metsLevels, this.mappingAdapter);
            this.exportMetadata(packageSIP, (NodeFolder)targetRootNode);
            this.exportMetadataFile(eCH0160SipPath, (NodeFolder)targetRootNode);
            this.metsDocument.saveWithoutBackup();
            this.metsDocument.cleanupWorkingCopy();
            Path path = metsSIPPath;
            return path;
        }
        catch (FileAlreadyExistsException | IncompatibleMappingAndLevelsException | UnhandledEchValueTypeException ex) {
            this.cleanupAtExceptionHandling();
            throw ex;
        }
        catch (Exception e) {
            this.cleanupAtExceptionHandling();
            throw new ExportException("generateMetsSIP failed", e);
        }
        finally {
            if (this.metsDocument != null) {
                this.metsDocument.unlockIfNecessary();
            }
        }
    }

    private void cleanupAtExceptionHandling() {
        if (this.metsDocument != null) {
            try {
                this.metsDocument.cleanupWorkingCopy();
            }
            catch (FileUtilExceptionListException e1) {
                Logger.warn((java.lang.Object)((java.lang.Object)e1));
            }
            try {
                FileUtils.deleteDirectory((File)new File(this.metsDocument.getFilePath()).getParentFile());
            }
            catch (IOException e2) {
                Logger.warn((java.lang.Object)e2);
            }
        }
    }

    void validateMappingAgainstMetsLevels(LevelOfDescriptionSet metsLevels_, MappingAdapter mappingAdapter_) throws IncompatibleMappingAndLevelsException {
        List mappedLevels;
        List allMetsLevels = metsLevels_.getAll().stream().map(level -> level.getName()).collect(Collectors.toList());
        if (!allMetsLevels.containsAll(mappedLevels = mappingAdapter_.getMappedLevels().values().stream().map(levelType -> levelType.getMatterhorn()).collect(Collectors.toList()))) {
            Logger.error((java.lang.Object)"mapping and levels are not compatible");
            throw new IncompatibleMappingAndLevelsException("mapping and levels are not compatible: mappedLevels should be a subset of allMetsLevels");
        }
    }

    private void exportMetadataFile(Path eCH0160SipPath, NodeFolder parentNode) throws FileNotFoundException, IOException, FileAlreadyExistsException, FileOperationNotAllowedException, FileUtilExceptionListException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, FolderNameIsEmptyException {
        if (this.mappingAdapter.getMetadataXML().getInclude().contains(INCLUDE_METADATA_FILE)) {
            String configuredLevel;
            Path metadataPath = eCH0160SipPath.resolve(HEADER_FOLDER).resolve(METADATA_FILE_NAME);
            NodeAbstract fileNode = parentNode.insertFileOrFolder(metadataPath.toString(), true);
            if (this.mappingAdapter.getMetadataXML().getTitle() != null) {
                fileNode.setUnitTitle(this.mappingAdapter.getMetadataXML().getTitle());
            }
            if ((configuredLevel = this.mappingAdapter.getMetadataXML().getLevel()) != null) {
                fileNode.setLevel(this.metsLevels.get(configuredLevel));
            } else {
                fileNode.setLevel(this.metsLevels.getUndefined());
            }
        }
    }

    private void exportMetadata(PaketSIP packageSIP, NodeFolder targetRootNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        if (this.mappingAdapter.isIgnoreEmptyElement()) {
            this.notEmptyElementsIds = this.getAllNotEmptyElements(packageSIP);
        }
        this.exportFromRoot(packageSIP, targetRootNode);
    }

    private Set<String> getAllNotEmptyElements(PaketSIP packageSIP) {
        HashSet<String> entitiesIds = new HashSet();
        this.listOfListOfIds = new ArrayList<List<String>>();
        AblieferungSIP ablieferung = packageSIP.getAblieferung();
        if (ablieferung instanceof AblieferungGeverSIP) {
            OrdnungssystemGeverSIP ordnungssystem = ((AblieferungGeverSIP)ablieferung).getOrdnungssystem();
            List<OrdnungssystempositionGeverSIP> ordnungssystempositions = ordnungssystem.getOrdnungssystemposition();
            for (OrdnungssystempositionGeverSIP ordnungssystemposition : ordnungssystempositions) {
                this.getEntitiesIdsRecursive(ordnungssystemposition, this.listOfListOfIds);
                this.addToAllLists(this.listOfListOfIds, ordnungssystemposition.getId());
            }
        } else if (ablieferung instanceof AblieferungFilesSIP) {
            OrdnungssystemFilesSIP ordnungssystem = ((AblieferungFilesSIP)ablieferung).getOrdnungssystem();
            List<OrdnungssystempositionFilesSIP> ordnungssystempositions = ordnungssystem.getOrdnungssystemposition();
            for (OrdnungssystempositionFilesSIP ordnungssystemposition : ordnungssystempositions) {
                this.getEntitiesIdsRecursive(ordnungssystemposition, this.listOfListOfIds);
                this.addToAllLists(this.listOfListOfIds, ordnungssystemposition.getId());
            }
        }
        entitiesIds = this.listOfListOfIds.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return entitiesIds;
    }

    List<List<String>> getListOfListOfIds() {
        return this.listOfListOfIds;
    }

    Set<String> getNotEmptyElementsIds() {
        return this.notEmptyElementsIds;
    }

    private void getEntitiesIdsRecursive(OrdnungssystempositionGeverSIP ordnungssystemposition, List<List<String>> listOfListOfIds) {
        List<OrdnungssystempositionGeverSIP> ordnungssystempositionList = ordnungssystemposition.getOrdnungssystemposition();
        for (OrdnungssystempositionGeverSIP ordnungssystempositionEntity : ordnungssystempositionList) {
            this.getEntitiesIdsRecursive(ordnungssystempositionEntity, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, ordnungssystempositionEntity.getId());
        }
        List<DossierGeverSIP> dossiers = ordnungssystemposition.getDossier();
        for (DossierGeverSIP dossier : dossiers) {
            this.getEntitiesIdsRecursive(dossier, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, dossier.getId());
        }
    }

    private void getEntitiesIdsRecursive(OrdnungssystempositionFilesSIP ordnungssystemposition, List<List<String>> listOfListOfIds) {
        List<OrdnungssystempositionFilesSIP> ordnungssystempositionList = ordnungssystemposition.getOrdnungssystemposition();
        for (OrdnungssystempositionFilesSIP ordnungssystempositionEntity : ordnungssystempositionList) {
            this.getEntitiesIdsRecursive(ordnungssystempositionEntity, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, ordnungssystempositionEntity.getId());
        }
        List<DossierFilesSIP> dossiers = ordnungssystemposition.getDossier();
        for (DossierFilesSIP dossier : dossiers) {
            this.getEntitiesIdsRecursive(dossier, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, dossier.getId());
        }
    }

    private void getEntitiesIdsRecursive(DossierGeverSIP dossier, List<List<String>> listOfListOfIds) {
        List<DossierGeverSIP> dossierList = dossier.getDossier();
        for (DossierGeverSIP childDossier : dossierList) {
            this.getEntitiesIdsRecursive(childDossier, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, childDossier.getId());
        }
        List<DokumentGeverSIP> dokuments = dossier.getDokument();
        for (DokumentGeverSIP dokument : dokuments) {
            List<JAXBElement<List<java.lang.Object>>> dateiRefList = dokument.getDateiRef();
            this.getEntitiesIdsRecursive(dateiRefList, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, dokument.getId());
        }
    }

    private void getEntitiesIdsRecursive(DossierFilesSIP dossier, List<List<String>> listOfListOfIds) {
        List<DossierFilesSIP> dossierList = dossier.getDossier();
        for (DossierFilesSIP childDossier : dossierList) {
            this.getEntitiesIdsRecursive(childDossier, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, childDossier.getId());
        }
        List<JAXBElement<List<java.lang.Object>>> dateiRefList = dossier.getDateiRef();
        this.getEntitiesIdsRecursive(dateiRefList, listOfListOfIds);
        List<DokumentFilesSIP> dokuments = dossier.getDokument();
        for (DokumentFilesSIP dokument : dokuments) {
            dateiRefList = dokument.getDateiRef();
            this.getEntitiesIdsRecursive(dateiRefList, listOfListOfIds);
            this.addToAllLists(listOfListOfIds, dokument.getId());
        }
    }

    private void addToAllLists(List<List<String>> listOfListOfIds, String id) {
        for (List<String> list : listOfListOfIds) {
            list.add(id);
        }
    }

    private void getEntitiesIdsRecursive(List<JAXBElement<List<java.lang.Object>>> dateiRefList, List<List<String>> listOfListOfIds) {
        for (JAXBElement<List<java.lang.Object>> dateiRef : dateiRefList) {
            for (java.lang.Object object : (List)dateiRef.getValue()) {
                ArrayList<String> newList = new ArrayList<String>();
                String id = ((DateiSIP)object).getId();
                newList.add(id);
                listOfListOfIds.add(newList);
            }
        }
    }

    private void exportFromRoot(PaketSIP packageSIP, NodeFolder targetRootNode) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        block3: {
            AblieferungSIP ablieferung;
            NodeFolder currentNodeFolder;
            block2: {
                currentNodeFolder = null;
                String matterhornLevel = this.getMatterhornLevel(MappingAdapter.ECH_LEVELS.Paket);
                targetRootNode.setLevel(this.metsLevels.get(matterhornLevel));
                ablieferung = packageSIP.getAblieferung();
                currentNodeFolder = this.exportEntity(ablieferung, MappingAdapter.ECH_LEVELS.Ablieferung, targetRootNode, LABEL_ABLIEFERUNG);
                if (!(ablieferung instanceof AblieferungGeverSIP)) break block2;
                ProvenienzGeverSIP provenienz = ((AblieferungGeverSIP)ablieferung).getProvenienz();
                this.exportEntity(provenienz, MappingAdapter.ECH_LEVELS.Provenienz, currentNodeFolder, LABEL_PROVENIENZ);
                OrdnungssystemGeverSIP ordnungssystem = ((AblieferungGeverSIP)ablieferung).getOrdnungssystem();
                currentNodeFolder = this.exportEntity(ordnungssystem, MappingAdapter.ECH_LEVELS.Ordnungssytem, currentNodeFolder, LABEL_ORDNUNGSSYSTEM);
                List<OrdnungssystempositionGeverSIP> ordnungssystempositions = ordnungssystem.getOrdnungssystemposition();
                for (OrdnungssystempositionGeverSIP ordnungssystemposition : ordnungssystempositions) {
                    this.exportOrdnungssystempositionRecursive(ordnungssystemposition, currentNodeFolder);
                }
                break block3;
            }
            if (!(ablieferung instanceof AblieferungFilesSIP)) break block3;
            ProvenienzFilesSIP provenienz = ((AblieferungFilesSIP)ablieferung).getProvenienz();
            this.exportEntity(provenienz, MappingAdapter.ECH_LEVELS.Provenienz, currentNodeFolder, LABEL_PROVENIENZ);
            OrdnungssystemFilesSIP ordnungssystem = ((AblieferungFilesSIP)ablieferung).getOrdnungssystem();
            currentNodeFolder = this.exportEntity(ordnungssystem, MappingAdapter.ECH_LEVELS.Ordnungssytem, currentNodeFolder, LABEL_ORDNUNGSSYSTEM);
            List<OrdnungssystempositionFilesSIP> ordnungssystempositions = ordnungssystem.getOrdnungssystemposition();
            for (OrdnungssystempositionFilesSIP ordnungssystemposition : ordnungssystempositions) {
                this.exportOrdnungssystempositionRecursive(ordnungssystemposition, currentNodeFolder);
            }
        }
    }

    private String getMatterhornLevel(MappingAdapter.ECH_LEVELS eCH0160Level) {
        String matterhornLevel = "Undefined";
        LevelType levelType = this.mappedLevels.get((java.lang.Object)eCH0160Level);
        if (levelType != null) {
            matterhornLevel = levelType.getMatterhorn();
        }
        return matterhornLevel;
    }

    private NodeFolder exportEntity(java.lang.Object echEntity, MappingAdapter.ECH_LEVELS echLevelName, NodeFolder parent, String folderName) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        LevelType level = this.mappedLevels.get((java.lang.Object)echLevelName);
        NodeFolder newFolder = parent;
        if (this.isLevelEligibleForExport(echLevelName) && (newFolder = parent.createNewFolder(folderName, true)) != null) {
            newFolder.setLevel(this.metsLevels.get(level.getMatterhorn()));
            this.setMetadataFields(echEntity, level, (NodeAbstract)newFolder);
        }
        return newFolder;
    }

    private NodeFolder exportEntity(java.lang.Object echEntity, String id, MappingAdapter.ECH_LEVELS echLevelName, NodeFolder parent, String folderName) throws IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, FileAlreadyExistsException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        NodeFolder newFolder = parent;
        if (this.isEntityEligibleForExport(echLevelName, id)) {
            newFolder = parent.createNewFolder(folderName, true);
            LevelType level = this.mappedLevels.get((java.lang.Object)echLevelName);
            newFolder.setLevel(this.metsLevels.get(level.getMatterhorn()));
            this.setMetadataFields(echEntity, level, (NodeAbstract)newFolder);
        }
        return newFolder;
    }

    private boolean isLevelEligibleForExport(MappingAdapter.ECH_LEVELS levelName) {
        boolean isEligible = MappingAdapter.ECH_LEVELS.Provenienz.equals((java.lang.Object)levelName) || MappingAdapter.ECH_LEVELS.Ablieferung.equals((java.lang.Object)levelName) || MappingAdapter.ECH_LEVELS.Ordnungssytem.equals((java.lang.Object)levelName);
        isEligible &= this.mappedLevels.containsKey((java.lang.Object)levelName);
        if (this.mappingAdapter.isIgnoreEmptyElement()) {
            isEligible &= !this.notEmptyElementsIds.isEmpty();
        }
        return isEligible;
    }

    private boolean isEntityEligibleForExport(MappingAdapter.ECH_LEVELS echLevelName, String id) {
        return this.mappedLevels.containsKey((java.lang.Object)echLevelName) && this.isNotEmptyElement(id);
    }

    private boolean isNotEmptyElement(String id) {
        if (this.mappingAdapter.isIgnoreEmptyElement()) {
            return this.notEmptyElementsIds.contains(id);
        }
        return true;
    }

    private NodeFolder exportOrdnungssystempositionRecursive(OrdnungssystempositionGeverSIP ordnungssystemposition, NodeFolder parent) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        String folderName = this.getFolderName(ordnungssystemposition.getNummer(), ordnungssystemposition.getId());
        NodeFolder newFolder = this.exportEntity(ordnungssystemposition, ordnungssystemposition.getId(), MappingAdapter.ECH_LEVELS.Ordnungssytemposition, parent, folderName);
        List<DossierGeverSIP> dossiers = ordnungssystemposition.getDossier();
        for (DossierGeverSIP dossier : dossiers) {
            this.exportDossierRecursive(dossier, newFolder);
        }
        List<OrdnungssystempositionGeverSIP> ordnungssystempositionList = ordnungssystemposition.getOrdnungssystemposition();
        for (OrdnungssystempositionGeverSIP ordnungssystempositionEntity : ordnungssystempositionList) {
            this.exportOrdnungssystempositionRecursive(ordnungssystempositionEntity, newFolder);
        }
        return newFolder;
    }

    private NodeFolder exportOrdnungssystempositionRecursive(OrdnungssystempositionFilesSIP ordnungssystemposition, NodeFolder parent) throws IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, FileAlreadyExistsException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        String folderName = this.getFolderName(ordnungssystemposition.getNummer(), ordnungssystemposition.getId());
        NodeFolder newFolder = this.exportEntity(ordnungssystemposition, ordnungssystemposition.getId(), MappingAdapter.ECH_LEVELS.Ordnungssytemposition, parent, folderName);
        List<DossierFilesSIP> dossiers = ordnungssystemposition.getDossier();
        for (DossierFilesSIP dossier : dossiers) {
            this.exportDossierRecursive(dossier, newFolder);
        }
        List<OrdnungssystempositionFilesSIP> ordnungssystempositionList = ordnungssystemposition.getOrdnungssystemposition();
        for (OrdnungssystempositionFilesSIP ordnungssystempositionEntity : ordnungssystempositionList) {
            this.exportOrdnungssystempositionRecursive(ordnungssystempositionEntity, newFolder);
        }
        return newFolder;
    }

    private void exportDossierRecursive(DossierGeverSIP dossier, NodeFolder parent) throws IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, FileAlreadyExistsException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        String folderName = this.getFolderName(dossier.getAktenzeichen(), dossier.getId());
        NodeFolder parentFolder = this.exportEntity(dossier, dossier.getId(), MappingAdapter.ECH_LEVELS.Dossier, parent, folderName);
        List<DokumentGeverSIP> dokuments = dossier.getDokument();
        for (DokumentGeverSIP dokument : dokuments) {
            this.exportDokument(dokument, parentFolder);
        }
        List<DossierGeverSIP> dossierList = dossier.getDossier();
        for (DossierGeverSIP childDossier : dossierList) {
            this.exportDossierRecursive(childDossier, parentFolder);
        }
    }

    private void exportDossierRecursive(DossierFilesSIP dossier, NodeFolder parent) throws IllegalAccessException, InvocationTargetException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, FileAlreadyExistsException, IllegalArgumentException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        String folderName = this.getFolderName(dossier.getAktenzeichen(), dossier.getId());
        NodeFolder parentFolder = this.exportEntity(dossier, dossier.getId(), MappingAdapter.ECH_LEVELS.Dossier, parent, folderName);
        List<DokumentFilesSIP> dokuments = dossier.getDokument();
        for (DokumentFilesSIP dokument : dokuments) {
            this.exportDokument(dokument, parentFolder);
        }
        List<JAXBElement<List<java.lang.Object>>> dateiRefList = dossier.getDateiRef();
        this.exportDateiRefList(dateiRefList, parentFolder);
        List<DossierFilesSIP> dossierList = dossier.getDossier();
        for (DossierFilesSIP childDossier : dossierList) {
            this.exportDossierRecursive(childDossier, parentFolder);
        }
    }

    private String getFolderName(String preferredId, String fallbackId) {
        String folderName = fallbackId;
        if (preferredId != null && !preferredId.isEmpty()) {
            folderName = preferredId;
        }
        if (folderName == null || folderName.isEmpty()) {
            folderName = UniqueID.getString();
        }
        return folderName;
    }

    private void exportDokument(Dokument dokument, NodeFolder parent) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, FileAlreadyExistsException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        NodeFolder parentFolder = this.exportEntity(dokument, dokument.getId(), MappingAdapter.ECH_LEVELS.Dokument, parent, dokument.getId());
        List<JAXBElement<List<java.lang.Object>>> dateiRefList = dokument.getDateiRef();
        this.exportDateiRefList(dateiRefList, parentFolder);
    }

    private void exportDateiRefList(List<JAXBElement<List<java.lang.Object>>> dateiRefList, NodeFolder parentFolder) throws FileNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException, FileAlreadyExistsException, FileOperationNotAllowedException, FileUtilExceptionListException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException, FolderNameIsEmptyException {
        for (JAXBElement<List<java.lang.Object>> dateiRef : dateiRefList) {
            for (java.lang.Object object : (List)dateiRef.getValue()) {
                this.exportDatei((DateiSIP)object, parentFolder);
            }
        }
    }

    private void exportDatei(DateiSIP datei, NodeFolder parent) throws FileNotFoundException, IOException, FileAlreadyExistsException, FileOperationNotAllowedException, FileUtilExceptionListException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MessageDigestException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException, FolderNameIsEmptyException {
        if (!this.isEntityEligibleForExport(MappingAdapter.ECH_LEVELS.Datei, datei.getId())) {
            return;
        }
        try {
            FileChecksumCalculator.Algorithm algorithm = algorithmMap.get((java.lang.Object)datei.getPruefalgorithmus());
            if (!Object.getDefaultMessageDigestAlgorithm().equals((java.lang.Object)algorithm)) {
                Object.setDefaultMessageDigestAlgorithm((FileChecksumCalculator.Algorithm)algorithm);
            }
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)"at exportDatei when setDefaultMessageDigestAlgorithm");
        }
        ContentFile contentFile = this.idToContentFileMap.get(datei.getId());
        Path childPath = contentFile.getPath();
        NodeFile fileNode = (NodeFile)parent.insertFileOrFolder(childPath.toString(), true);
        LevelType level = this.mappedLevels.get((java.lang.Object)MappingAdapter.ECH_LEVELS.Datei);
        fileNode.setLevel(this.metsLevels.get(level.getMatterhorn()));
        this.setMetadataFields(datei, level, (NodeAbstract)fileNode);
        this.validateMETSMessageDigest(contentFile, (NodeAbstract)fileNode);
    }

    private void validateMETSMessageDigest(ContentFile contentFile, NodeAbstract fileNode) throws MessageDigestException {
        boolean checked = false;
        Object premisObject = fileNode.getDocument().getAMDSection().getDigiprov(fileNode.getAdmId()).getLastObject();
        String expectedDigest = contentFile.getDatei().getPruefsumme();
        String actualDigest = premisObject.getMessageDigest();
        if (actualDigest.compareToIgnoreCase(expectedDigest) != 0) {
            String s = "messageDigest not ok for filePath: '" + contentFile.getPath() + "', expected: " + expectedDigest + " , actual: " + actualDigest;
            MessageDigestException e = new MessageDigestException(s);
            Logger.error((java.lang.Object)e);
            throw e;
        }
        checked = true;
        if (!checked) {
            String s = "messageDigest not found for filePath: " + contentFile.getPath();
            MessageDigestException e = new MessageDigestException(s);
            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void setMetadataFields(java.lang.Object echEntity, LevelType level, NodeAbstract node) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, MetadataElementValidatorException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, LevelMetadataElementIsReadOnly, MetadataElementSetterPostActionException, MetadataElementAllowedValuesException, MetadataElementCantAddException, EvalError, UnhandledEchValueTypeException {
        List<FieldType> fields = level.getField();
        for (FieldType field : fields) {
            String echFieldName = field.getEch();
            String matterhornFieldName = field.getMatterhorn().value();
            Optional<java.lang.Object> optionalValue = this.getValueForField(echEntity, echFieldName);
            if (optionalValue.isPresent()) {
                java.lang.Object value = optionalValue.get();
                if (value instanceof String) {
                    if (((String)value).trim().isEmpty()) continue;
                    if (matterhornFieldName.equals(UNIT_TITLE)) {
                        node.setUnitTitle(value.toString());
                        continue;
                    }
                    node.setDynamicMetadataValueForName(matterhornFieldName, value.toString());
                    continue;
                }
                if (value instanceof Enum) {
                    node.setDynamicMetadataValueForName(matterhornFieldName, ((Enum)value).name());
                    continue;
                }
                if (value instanceof Boolean) {
                    node.setDynamicMetadataValueForName(matterhornFieldName, value.toString());
                    continue;
                }
                if (value instanceof HistorischerZeitraum) {
                    String fromDate = ((HistorischerZeitraum)value).getVon().getDatum();
                    String toDate = ((HistorischerZeitraum)value).getBis().getDatum();
                    node.setDynamicMetadataValueForName(matterhornFieldName, fromDate + " - " + toDate);
                    continue;
                }
                if (value instanceof HistorischerZeitpunkt) {
                    String date = ((HistorischerZeitpunkt)value).getDatum();
                    node.setDynamicMetadataValueForName(matterhornFieldName, date);
                    continue;
                }
                if (value instanceof ZusatzDaten) {
                    List<ZusatzDaten.Merkmal> merkmals = ((ZusatzDaten)value).getMerkmal();
                    int lastAdded = 0;
                    for (ZusatzDaten.Merkmal merkmal : merkmals) {
                        node.addDynamicMetadataElementInstanceWithName(matterhornFieldName);
                        node.setDynamicMetadataValueForName(matterhornFieldName, lastAdded++, merkmal.getName() + VALUE_DELIMITER + merkmal.getValue());
                    }
                    continue;
                }
                if (value instanceof List) {
                    int lastAdded = 0;
                    for (java.lang.Object item : (List)value) {
                        if (item instanceof EigenschaftDatei) {
                            String name = ((EigenschaftDatei)item).getName();
                            String val = ((EigenschaftDatei)item).getValue();
                            node.addDynamicMetadataElementInstanceWithName(matterhornFieldName);
                            node.setDynamicMetadataValueForName(matterhornFieldName, lastAdded++, name + VALUE_DELIMITER + val);
                            continue;
                        }
                        if (!(item instanceof String) || ((String)item).isEmpty()) continue;
                        node.addDynamicMetadataElementInstanceWithName(matterhornFieldName);
                        node.setDynamicMetadataValueForName(matterhornFieldName, lastAdded++, (String)item);
                    }
                    continue;
                }
                String message = String.format("value of eCH-0160 field '%s' has an unexpected type (%s) and can't be mapped", echEntity.getClass().getName(), value.getClass().getCanonicalName());
                throw new UnhandledEchValueTypeException(message);
            }
            Logger.debug((java.lang.Object)("ignoring 'null' value for eCH-0160 field '" + echFieldName + "'"));
        }
    }

    private Optional<java.lang.Object> getValueForField(java.lang.Object echEntity, String echFieldName) throws IllegalAccessException, InvocationTargetException {
        try {
            Method echMethod = echEntity.getClass().getMethod("get" + StringUtils.capitalize((String)echFieldName), new Class[0]);
            return Optional.ofNullable(echMethod.invoke(echEntity, new java.lang.Object[0]));
        }
        catch (NoSuchMethodException e1) {
            try {
                Method echMethod = echEntity.getClass().getMethod("is" + StringUtils.capitalize((String)echFieldName), new Class[0]);
                return Optional.ofNullable(echMethod.invoke(echEntity, new java.lang.Object[0]));
            }
            catch (NoSuchMethodException e2) {
                Logger.debug((java.lang.Object)("failed to get value for eCH-0160 field '" + echFieldName + "' from '" + echEntity.getClass().getName() + "'"));
                return Optional.empty();
            }
        }
    }

    static PaketSIP unmarshallPackageSIP(Path sourceSIPPath) throws InvalidSIPException {
        PaketSIP returnPaketSIP;
        try {
            File metadataFile = sourceSIPPath.resolve(HEADER_FOLDER).resolve(METADATA_FILE_NAME).toFile();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)CONTEXT_PATH_BAR_ARELDA);
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement jaxbElement = (JAXBElement)jaxbUnmarshaller.unmarshal(metadataFile);
            returnPaketSIP = (PaketSIP)jaxbElement.getValue();
        }
        catch (JAXBException e) {
            throw new InvalidSIPException("cannot unmarshal metadataFile");
        }
        if (!returnPaketSIP.getPaketTyp().equals((java.lang.Object)PaketTyp.SIP)) {
            throw new InvalidSIPException("PaketTyp is not SIP");
        }
        return returnPaketSIP;
    }

    public void cleanUp() {
        this.cleanupTempFile(this.sourceSIPPath);
        this.cleanupTempFile(this.tempFolderPath);
    }

    private void cleanupTempFile(Path tempFilePath) {
        if (tempFilePath != null && tempFilePath.toFile().exists()) {
            try {
                FileUtils.deleteDirectory((File)tempFilePath.toFile());
            }
            catch (IOException e) {
                Logger.error((java.lang.Object)("cannot cleanup temporary file: " + tempFilePath));
            }
        }
    }

    private Path unzip(Path zipPath) throws IOException, InvalidSIPException {
        Logger.debug((java.lang.Object)("Unzipping '" + zipPath));
        this.tempFolderPath = Files.createTempDirectory(Paths.get(FileUtil.getTempFolder(), new String[0]), TMP_DIR_PREFIX, new FileAttribute[0]);
        Zipper.unzip((String)zipPath.toAbsolutePath().toString(), (String)this.tempFolderPath.toString());
        try (Stream<Path> pathStream = Files.find(this.tempFolderPath, 10, (path, attribute) -> path.toString().endsWith(METADATA_FILE_NAME), new FileVisitOption[0]);){
            if (pathStream.count() == 1L) {
                Stream<Path> stream = Files.find(this.tempFolderPath, 10, (path, attribute) -> path.toString().endsWith(METADATA_FILE_NAME), new FileVisitOption[0]);
                Optional<Path> optionalPath = stream.findAny();
                Path metadataPath = optionalPath.get();
                Path sipRootPath = metadataPath.getParent().getParent();
                stream.close();
                Path path2 = sipRootPath;
                return path2;
            }
            throw new InvalidSIPException("cannot find metadata.xml");
        }
    }

    PaketSIP getPackageSIP() {
        return this.packageSIP;
    }

    public Path getSourceSIPPath() {
        return this.sourceSIPPath;
    }

    static {
        algorithmMap.put(Pruefalgorithmus.MD_5, FileChecksumCalculator.Algorithm.MD5);
        algorithmMap.put(Pruefalgorithmus.SHA_1, FileChecksumCalculator.Algorithm.SHA1);
        algorithmMap.put(Pruefalgorithmus.SHA_256, FileChecksumCalculator.Algorithm.SHA256);
        algorithmMap.put(Pruefalgorithmus.SHA_512, FileChecksumCalculator.Algorithm.SHA512);
    }

    class ContentFile {
        DateiSIP datei;
        Path path;

        public ContentFile(DateiSIP datei, Path path) {
            this.datei = datei;
            this.path = path.resolve(datei.getName());
        }

        public String toString() {
            return "ContentFile [path=" + this.path + ", datei=" + this.datei.getName() + "]";
        }

        public DateiSIP getDatei() {
            return this.datei;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

