/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.Utf8Block;
import java.util.ArrayList;

public class Utf8BlockMarker {
    private boolean[] blocksUsed = new boolean[Utf8Block.unicodeBlock.length];

    public void markBlock(int code) {
        for (int i = 0; i < Utf8Block.unicodeBlock.length; ++i) {
            if (Utf8Block.unicodeBlock[i].getStart() > code || Utf8Block.unicodeBlock[i].getEnd() < code) continue;
            this.blocksUsed[i] = true;
            break;
        }
    }

    public Property getBlocksUsedProperty(String name) {
        ArrayList<String> block = new ArrayList<String>(this.blocksUsed.length);
        for (int i = 0; i < this.blocksUsed.length; ++i) {
            if (!this.blocksUsed[i]) continue;
            block.add(Utf8Block.unicodeBlock[i].getName());
        }
        if (block.isEmpty()) {
            return null;
        }
        return new Property(name, PropertyType.STRING, PropertyArity.LIST, block);
    }

    public void reset() {
        for (int i = 0; i < Utf8Block.unicodeBlock.length; ++i) {
            this.blocksUsed[i] = false;
        }
    }
}

