/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDInfoBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UUIDListBox
extends JP2Box {
    public UUIDListBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof UUIDInfoBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int nUUID = this._module.readUnsignedShort(this._dstrm);
        if ((long)(16 * nUUID + 2) != this._boxHeader.getDataLength()) {
            this.wrongBoxSize();
            return false;
        }
        byte[][] uuids = new byte[nUUID][];
        for (int i = 0; i < nUUID; ++i) {
            ModuleBase.readByteBuf((DataInputStream)this._dstrm, (byte[])uuids[i], (ModuleBase)this._module);
        }
        if (this._parentBox instanceof UUIDInfoBox) {
            ((UUIDInfoBox)this._parentBox).setUUIDList(uuids);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "UUID List Box";
    }
}

