/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.bytes;

import java.io.IOException;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.searcher.AbstractSearcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.utils.ArgUtils;

public final class ByteMatcherSearcher
extends AbstractSearcher<ByteMatcher> {
    private final ByteMatcher toSearchFor;

    public ByteMatcherSearcher(ByteMatcher value) {
        ArgUtils.checkNullObject(value, "ByteMatcher passed in cannot be null.");
        this.toSearchFor = value;
    }

    @Override
    public List<SearchResult<ByteMatcher>> searchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        long searchPosition;
        ByteMatcher searchByte = this.toSearchFor;
        long l = searchPosition = fromPosition >= 0L ? fromPosition : 0L;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long distanceToSearchEnd;
            byte[] array = window.getArray();
            int startWindowSearchPosition = reader.getWindowOffset(searchPosition);
            int distanceToWindowEnd = window.length() - 1 - startWindowSearchPosition;
            int endWindowSearchPosition = (long)distanceToWindowEnd < (distanceToSearchEnd = toPosition - searchPosition) ? startWindowSearchPosition + distanceToWindowEnd : startWindowSearchPosition + (int)distanceToSearchEnd;
            for (int arraySearchPosition = startWindowSearchPosition; arraySearchPosition <= endWindowSearchPosition; ++arraySearchPosition) {
                if (!searchByte.matches(array[arraySearchPosition])) continue;
                long matchPosition = searchPosition + (long)arraySearchPosition - (long)startWindowSearchPosition;
                return SearchUtils.singleResult(matchPosition, searchByte);
            }
            searchPosition += (long)(distanceToWindowEnd + 1);
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<ByteMatcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        ByteMatcher searchByte = this.toSearchFor;
        int startPosition = fromPosition >= 0 ? fromPosition : 0;
        int endPosition = toPosition < bytes.length ? toPosition : bytes.length - 1;
        for (int searchPosition = startPosition; searchPosition <= endPosition; ++searchPosition) {
            if (!searchByte.matches(bytes[searchPosition])) continue;
            return SearchUtils.singleResult(searchPosition, searchByte);
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<ByteMatcher>> searchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int startWindowSearchPosition;
        ByteMatcher searchByte = this.toSearchFor;
        for (long searchPosition = fromPosition; searchPosition >= toPosition && (window = reader.getWindow(searchPosition)) != null; searchPosition -= (long)(startWindowSearchPosition + 1)) {
            byte[] array = window.getArray();
            long distanceToSearchEnd = searchPosition - toPosition;
            startWindowSearchPosition = reader.getWindowOffset(searchPosition);
            int endWindowSearchPosition = distanceToSearchEnd > (long)startWindowSearchPosition ? 0 : startWindowSearchPosition - (int)distanceToSearchEnd;
            for (int arraySearchPosition = startWindowSearchPosition; arraySearchPosition >= endWindowSearchPosition; --arraySearchPosition) {
                if (!searchByte.matches(array[arraySearchPosition])) continue;
                long matchPosition = searchPosition - (long)(startWindowSearchPosition - arraySearchPosition);
                return SearchUtils.singleResult(matchPosition, searchByte);
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<ByteMatcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        ByteMatcher searchByte = this.toSearchFor;
        int startPosition = fromPosition < bytes.length ? fromPosition : bytes.length - 1;
        int endPosition = toPosition > 0 ? toPosition : 0;
        for (int searchPosition = startPosition; searchPosition >= endPosition; --searchPosition) {
            if (!searchByte.matches(bytes[searchPosition])) continue;
            return SearchUtils.singleResult(searchPosition, searchByte);
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
    }

    @Override
    public void prepareBackwards() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toSearchFor + ']';
    }
}

