--------------------------------------------------------
--  Datei erstellt -Donnerstag-November-13-2014   
--------------------------------------------------------
-- Wiedergabe von TABLE DDL für Objekt INGEST_TRACKING_RECORD_FEEDER nicht möglich, da DBMS_METADATA internen Generator versucht.

DROP TABLE INGEST_TRACKING_RECORD_FEEDER;
CREATE TABLE INGEST_TRACKING_RECORD_FEEDER 
(
  WORKFLOW_EXECUTION_ID VARCHAR2(128 BYTE) NOT NULL 
, WORKSPACE_ID VARCHAR2(128 BYTE) NOT NULL 
, WORKSPACE_PATH VARCHAR2(4000 BYTE) NOT NULL 
, SUBMIT_TIMESTAMP DATE NOT NULL 
, SOURCE_PATH VARCHAR2(4000 BYTE) NOT NULL 
, CREATE_DT DATE NOT NULL 
, UPDATE_DT DATE NOT NULL 
, SIP_PATH VARCHAR2(1024 BYTE) 
, SIP_TYPE VARCHAR2(128 BYTE) NOT NULL 
, IE_DIGEST VARCHAR2(128 BYTE) 
, SIP_ID VARCHAR2(128 BYTE) 
, ARCH_PATH VARCHAR2(1024 BYTE) 
, SIP_STATUS VARCHAR2(128 BYTE) NOT NULL 
, AMD_ID VARCHAR2(20 BYTE) NOT NULL 
, SIP_NAME VARCHAR2(1024 BYTE) NOT NULL 
, ENTITY_ID VARCHAR2(128 BYTE) 
, INGEST_ID VARCHAR2(128 BYTE) 
, DOI VARCHAR2(50 BYTE)
, CONSTRAINT DOI_UNIQUE UNIQUE (DOI)
) 
LOGGING 
PCTFREE 10 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS UNLIMITED 
  BUFFER_POOL DEFAULT 
) 
NOCOMPRESS 
NOPARALLEL;
CREATE INDEX IDX_01_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (SIP_STATUS ASC) 
LOGGING 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS UNLIMITED 
  BUFFER_POOL DEFAULT 
) 
NOPARALLEL;
CREATE UNIQUE INDEX IDX_U01_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (SIP_TYPE ASC, SIP_PATH ASC, IE_DIGEST ASC) 
LOGGING 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS UNLIMITED 
  BUFFER_POOL DEFAULT 
) 
NOPARALLEL;
CREATE UNIQUE INDEX IDX_U02_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (WORKSPACE_ID ASC, WORKSPACE_PATH ASC, SUBMIT_TIMESTAMP ASC) 
LOGGING 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS UNLIMITED 
  BUFFER_POOL DEFAULT 
) 
NOPARALLEL;
CREATE UNIQUE INDEX IDX_U03_ING_TRACK_REC_FEEDER ON INGEST_TRACKING_RECORD_FEEDER (WORKSPACE_ID ASC, SIP_NAME ASC, AMD_ID ASC) 
LOGGING 
PCTFREE 10 
INITRANS 2 
STORAGE 
( 
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1 
  MAXEXTENTS UNLIMITED 
  BUFFER_POOL DEFAULT 
) 
NOPARALLEL;

COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.WORKFLOW_EXECUTION_ID IS 'Execution Id created by Docuteam Feeder';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.WORKSPACE_ID IS 'Workspace Id configured for certain workspace';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.WORKSPACE_PATH IS 'Path within workspace of certain Docupack item (IE or Collection)';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.SUBMIT_TIMESTAMP IS 'Timestamp when manual submission in Docuteam packer is initialized';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.SOURCE_PATH IS 'Path within Feeder work area for certain item (IE or Collection)';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.CREATE_DT IS 'Creation date of tracking record';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.UPDATE_DT IS 'Last update date of tracking record';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.SIP_PATH IS 'SIP ingest path used as source path by ETH ingest application';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.SIP_TYPE IS 'Type of SIP being submitted (IE or Collection)';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.IE_DIGEST IS 'Digest for recognizing resubmission';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.SIP_ID IS 'SIP Id delivered by Rosetta';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.ARCH_PATH IS 'Archive path of ingest object';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.SIP_STATUS IS 'SIP status according to ETH defined status model';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.AMD_ID IS 'Objekt-ID innerhalb des AIPs';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.SIP_NAME IS 'The name of the delivered SIP';
COMMENT ON COLUMN INGEST_TRACKING_RECORD_FEEDER.ENTITY_ID IS 'Rosetta generated ID for either Collection or IE.';

SET DEFINE OFF;
