/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;

public class MemBNode
extends MemResource
implements BNode {
    private static final long serialVersionUID = -887382892580321647L;
    private final transient Object creator;
    private final transient MemStatementList objectStatements = new MemStatementList();
    private final String id;

    public MemBNode(Object creator, String id) {
        this.id = id;
        this.creator = creator;
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return !this.subjectStatements.isEmpty() || !this.objectStatements.isEmpty() || !this.contextStatements.isEmpty();
    }

    @Override
    public MemStatementList getObjectStatementList() {
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        return this.objectStatements.size();
    }

    @Override
    public void addObjectStatement(MemStatement st) throws InterruptedException {
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) throws InterruptedException {
        this.objectStatements.remove(st);
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) throws InterruptedException {
        this.objectStatements.cleanSnapshots(currentSnapshot);
    }

    @Override
    public boolean hasPredicateStatements() {
        return false;
    }

    @Override
    public boolean hasObjectStatements() {
        return !this.objectStatements.isEmpty();
    }

    public String getID() {
        return this.id;
    }

    public String stringValue() {
        return this.getID();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BNode && this.getID().equals(((BNode)o).getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        return "_:" + this.getID();
    }
}

