/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.cron;

import com.exlibris.core.sdk.cron.PeriodObject;
import java.util.Calendar;

public class CronObject
implements Cloneable {
    private PeriodObject dayObject;
    private PeriodObject monthObject;
    private String year;
    private String second;
    private String minute;
    private String hour;
    private String hourInterval;
    private PeriodObject dayOfweekObject;

    public CronObject() {
        Calendar calendar = Calendar.getInstance();
        this.setValues(calendar);
    }

    public CronObject(int nextMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, nextMinutes);
        this.setValues(calendar);
    }

    private void setValues(Calendar calendar) {
        this.second = String.valueOf(calendar.get(13));
        this.minute = String.valueOf(calendar.get(12));
        this.hour = String.valueOf(calendar.get(11));
        this.hourInterval = null;
        this.dayObject = new PeriodObject(String.valueOf(calendar.get(5)), 31);
        this.monthObject = new PeriodObject(String.valueOf(calendar.get(2) + 1), 12);
        this.dayOfweekObject = new PeriodObject(String.valueOf(calendar.get(7)), 7);
        this.year = String.valueOf(calendar.get(1));
    }

    public PeriodObject getDayObject() {
        return this.dayObject;
    }

    public String getDay() {
        return this.dayObject.getPeriod();
    }

    public void setDayObject(PeriodObject dayObject) {
        this.dayObject = dayObject;
    }

    public void setDay(String day) {
        this.dayObject.setPeriod(day);
    }

    public PeriodObject getMonthObject() {
        return this.monthObject;
    }

    public String getMonth() {
        return this.monthObject.getPeriod();
    }

    public void setMonthObject(PeriodObject monthObject) {
        this.monthObject = monthObject;
    }

    public void setMonth(String month) {
        this.monthObject.setPeriod(month);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getSecond() {
        return this.second;
    }

    public void setSecond(String second) {
        this.second = second;
    }

    public String getMinute() {
        return this.minute;
    }

    public void setMinute(String minute) {
        this.minute = minute;
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public String getHourInterval() {
        return this.hourInterval;
    }

    public void setHourInterval(String hourInterval) {
        this.hourInterval = hourInterval;
    }

    public PeriodObject getDayOfweekObject() {
        return this.dayOfweekObject;
    }

    public String getDayOfweek() {
        return this.dayOfweekObject.getPeriod();
    }

    public void setDayOfweekObject(PeriodObject dayOfweekObject) {
        this.dayOfweekObject = dayOfweekObject;
    }

    public void setDayOfweek(String dayOfweek) {
        this.dayOfweekObject.setPeriod(dayOfweek);
    }

    public String getFullDate() {
        String day = this.getFullPeriodSyntax(this.dayObject.getPeriod());
        String month = this.getFullPeriodSyntax(this.monthObject.getPeriod());
        return day + "." + month + "." + this.year;
    }

    public String getFullTime() {
        return this.getFullPeriodSyntax(this.minute) + "." + this.getFullPeriodSyntax(this.hour);
    }

    private String getFullPeriodSyntax(String period) {
        if (period.length() == 1) {
            period = "0" + period;
        }
        return period;
    }

    protected CronObject clone() throws CloneNotSupportedException {
        CronObject clone = (CronObject)super.clone();
        clone.setSecond(this.second);
        clone.setMinute(this.minute);
        clone.setHour(this.hour);
        clone.setHourInterval(this.hourInterval);
        clone.setYear(this.year);
        clone.setDayObject(this.dayObject.clone());
        clone.setDayOfweekObject(this.dayOfweekObject.clone());
        clone.setMonthObject(this.monthObject.clone());
        return clone;
    }
}

