/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.intermediate.ArcToBezierCurveTransformer;
import org.apache.fop.render.intermediate.BezierCurvePainter;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.render.intermediate.GraphicsPainter;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSGraphicsPainter
implements GraphicsPainter,
BezierCurvePainter {
    private static Log log = LogFactory.getLog(PSGraphicsPainter.class);
    private final PSGenerator generator;
    private final ArcToBezierCurveTransformer arcToBezierCurveTransformer;

    public PSGraphicsPainter(PSGenerator generator) {
        this.generator = generator;
        this.arcToBezierCurveTransformer = new ArcToBezierCurveTransformer(this);
    }

    @Override
    public void drawBorderLine(int x1, int y1, int x2, int y2, boolean horz, boolean startOrBefore, int style, Color col) throws IOException {
        PSGraphicsPainter.drawBorderLine(this.generator, PSGraphicsPainter.toPoints(x1), PSGraphicsPainter.toPoints(y1), PSGraphicsPainter.toPoints(x2), PSGraphicsPainter.toPoints(y2), horz, startOrBefore, style, col);
    }

    private static void drawLine(PSGenerator gen, float startx, float starty, float endx, float endy) throws IOException {
        gen.writeln(gen.formatDouble((double)startx) + " " + gen.formatDouble((double)starty) + " " + gen.mapCommand("moveto") + " " + gen.formatDouble((double)endx) + " " + gen.formatDouble((double)endy) + " " + gen.mapCommand("lineto") + " " + gen.mapCommand("stroke") + " " + gen.mapCommand("newpath"));
    }

    public static void drawBorderLine(PSGenerator gen, float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) throws IOException {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                gen.useColor(col);
                if (horz) {
                    float dashWidth = BorderPainter.dashWidthCalculator(w, h);
                    if (dashWidth != 0.0f) {
                        gen.useDash("[" + dashWidth + " " + 0.5f * dashWidth + "] 0");
                    }
                    gen.useLineCap(0);
                    gen.useLineWidth((double)h);
                    float ym = y1 + h / 2.0f;
                    PSGraphicsPainter.drawLine(gen, x1, ym, x2, ym);
                    break;
                }
                float dashWidth = BorderPainter.dashWidthCalculator(h, w);
                if (dashWidth != 0.0f) {
                    gen.useDash("[" + dashWidth + " " + 0.5f * dashWidth + "] 0");
                }
                gen.useLineCap(0);
                gen.useLineWidth((double)w);
                float xm = x1 + w / 2.0f;
                PSGraphicsPainter.drawLine(gen, xm, y1, xm, y2);
                break;
            }
            case 36: {
                gen.useColor(col);
                gen.useLineCap(1);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    gen.useDash("[0 " + unit + "] 0");
                    gen.useLineWidth((double)h);
                    float ym = y1 + h / 2.0f;
                    PSGraphicsPainter.drawLine(gen, x1, ym, x2, ym);
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                gen.useDash("[0 " + unit + "] 0");
                gen.useLineWidth((double)w);
                float xm = x1 + w / 2.0f;
                PSGraphicsPainter.drawLine(gen, xm, y1, xm, y2);
                break;
            }
            case 37: {
                gen.useColor(col);
                gen.useDash(null);
                if (horz) {
                    float h3 = h / 3.0f;
                    gen.useLineWidth((double)h3);
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    PSGraphicsPainter.drawLine(gen, x1, ym1, x2, ym1);
                    PSGraphicsPainter.drawLine(gen, x1, ym2, x2, ym2);
                    break;
                }
                float w3 = w / 3.0f;
                gen.useLineWidth((double)w3);
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                PSGraphicsPainter.drawLine(gen, xm1, y1, xm1, y2);
                PSGraphicsPainter.drawLine(gen, xm2, y1, xm2, y2);
                break;
            }
            case 55: 
            case 119: {
                float colFactor = style == 55 ? 0.4f : -0.4f;
                gen.useDash(null);
                if (horz) {
                    Color uppercol = ColorUtil.lightenColor(col, -colFactor);
                    Color lowercol = ColorUtil.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    gen.useLineWidth((double)h3);
                    float ym1 = y1 + h3 / 2.0f;
                    gen.useColor(uppercol);
                    PSGraphicsPainter.drawLine(gen, x1, ym1, x2, ym1);
                    gen.useColor(col);
                    PSGraphicsPainter.drawLine(gen, x1, ym1 + h3, x2, ym1 + h3);
                    gen.useColor(lowercol);
                    PSGraphicsPainter.drawLine(gen, x1, ym1 + h3 + h3, x2, ym1 + h3 + h3);
                    break;
                }
                Color leftcol = ColorUtil.lightenColor(col, -colFactor);
                Color rightcol = ColorUtil.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                gen.useLineWidth((double)w3);
                float xm1 = x1 + w3 / 2.0f;
                gen.useColor(leftcol);
                PSGraphicsPainter.drawLine(gen, xm1, y1, xm1, y2);
                gen.useColor(col);
                PSGraphicsPainter.drawLine(gen, xm1 + w3, y1, xm1 + w3, y2);
                gen.useColor(rightcol);
                PSGraphicsPainter.drawLine(gen, xm1 + w3 + w3, y1, xm1 + w3 + w3, y2);
                break;
            }
            case 67: 
            case 101: {
                float colFactor = style == 101 ? 0.4f : -0.4f;
                gen.useDash(null);
                if (horz) {
                    Color c = ColorUtil.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                    gen.useLineWidth((double)h);
                    float ym1 = y1 + h / 2.0f;
                    gen.useColor(c);
                    PSGraphicsPainter.drawLine(gen, x1, ym1, x2, ym1);
                    break;
                }
                Color c = ColorUtil.lightenColor(col, (float)(startOrBefore ? 1 : -1) * colFactor);
                gen.useLineWidth((double)w);
                float xm1 = x1 + w / 2.0f;
                gen.useColor(c);
                PSGraphicsPainter.drawLine(gen, xm1, y1, xm1, y2);
                break;
            }
            case 57: {
                break;
            }
            default: {
                gen.useColor(col);
                gen.useDash(null);
                gen.useLineCap(0);
                if (horz) {
                    gen.useLineWidth((double)h);
                    float ym = y1 + h / 2.0f;
                    PSGraphicsPainter.drawLine(gen, x1, ym, x2, ym);
                    break;
                }
                gen.useLineWidth((double)w);
                float xm = x1 + w / 2.0f;
                PSGraphicsPainter.drawLine(gen, xm, y1, xm, y2);
            }
        }
    }

    @Override
    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) throws IOException {
        if (start.y != end.y) {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }
        this.saveGraphicsState();
        int half = width / 2;
        int starty = start.y - half;
        switch (style.getEnumValue()) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(start.x, starty, end.x, starty + width, true, true, style.getEnumValue(), color);
                break;
            }
            case 36: {
                this.clipRect(start.x, starty, end.x - start.x, width);
                this.generator.concatMatrix(1.0, 0.0, 0.0, 1.0, (double)PSGraphicsPainter.toPoints(half), 0.0);
                this.drawBorderLine(start.x, starty, end.x, starty + width, true, true, style.getEnumValue(), color);
                break;
            }
            case 55: 
            case 119: {
                this.generator.useColor(ColorUtil.lightenColor(color, 0.6f));
                this.moveTo(start.x, starty);
                this.lineTo(end.x, starty);
                this.lineTo(end.x, starty + 2 * half);
                this.lineTo(start.x, starty + 2 * half);
                this.closePath();
                this.generator.write(" " + this.generator.mapCommand("fill"));
                this.generator.writeln(" " + this.generator.mapCommand("newpath"));
                this.generator.useColor(color);
                if (style == RuleStyle.GROOVE) {
                    this.moveTo(start.x, starty);
                    this.lineTo(end.x, starty);
                    this.lineTo(end.x, starty + half);
                    this.lineTo(start.x + half, starty + half);
                    this.lineTo(start.x, starty + 2 * half);
                } else {
                    this.moveTo(end.x, starty);
                    this.lineTo(end.x, starty + 2 * half);
                    this.lineTo(start.x, starty + 2 * half);
                    this.lineTo(start.x, starty + half);
                    this.lineTo(end.x - half, starty + half);
                }
                this.closePath();
                this.generator.write(" " + this.generator.mapCommand("fill"));
                this.generator.writeln(" " + this.generator.mapCommand("newpath"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        this.restoreGraphicsState();
    }

    private static float toPoints(int mpt) {
        return (float)mpt / 1000.0f;
    }

    @Override
    public void moveTo(int x, int y) throws IOException {
        this.generator.writeln(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(x)) + " " + this.generator.formatDouble((double)PSGraphicsPainter.toPoints(y)) + " " + this.generator.mapCommand("moveto"));
    }

    @Override
    public void lineTo(int x, int y) throws IOException {
        this.generator.writeln(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(x)) + " " + this.generator.formatDouble((double)PSGraphicsPainter.toPoints(y)) + " " + this.generator.mapCommand("lineto"));
    }

    @Override
    public void arcTo(double startAngle, double endAngle, int cx, int cy, int width, int height) throws IOException {
        this.arcToBezierCurveTransformer.arcTo(startAngle, endAngle, cx, cy, width, height);
    }

    @Override
    public void closePath() throws IOException {
        this.generator.writeln("cp");
    }

    private void clipRect(int x, int y, int width, int height) throws IOException {
        this.generator.defineRect((double)PSGraphicsPainter.toPoints(x), (double)PSGraphicsPainter.toPoints(y), (double)PSGraphicsPainter.toPoints(width), (double)PSGraphicsPainter.toPoints(height));
        this.clip();
    }

    @Override
    public void clip() throws IOException {
        this.generator.writeln(this.generator.mapCommand("clip") + " " + this.generator.mapCommand("newpath"));
    }

    @Override
    public void saveGraphicsState() throws IOException {
        this.generator.saveGraphicsState();
    }

    @Override
    public void restoreGraphicsState() throws IOException {
        this.generator.restoreGraphicsState();
    }

    @Override
    public void rotateCoordinates(double angle) throws IOException {
        StringBuffer sb = new StringBuffer().append(this.generator.formatDouble(angle * 180.0 / Math.PI)).append("  rotate ");
        this.generator.writeln(sb.toString());
    }

    @Override
    public void translateCoordinates(int xTranslate, int yTranslate) throws IOException {
        StringBuffer sb = new StringBuffer().append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(xTranslate))).append(" ").append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(yTranslate))).append("  translate ");
        this.generator.writeln(sb.toString());
    }

    @Override
    public void scaleCoordinates(float xScale, float yScale) throws IOException {
        StringBuffer sb = new StringBuffer().append(this.generator.formatDouble((double)xScale)).append(" ").append(this.generator.formatDouble((double)yScale)).append("  scale ");
        this.generator.writeln(sb.toString());
    }

    @Override
    public void cubicBezierTo(int p1x, int p1y, int p2x, int p2y, int p3x, int p3y) throws IOException {
        StringBuffer sb = new StringBuffer().append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(p1x))).append(" ").append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(p1y))).append(" ").append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(p2x))).append(" ").append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(p2y))).append(" ").append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(p3x))).append(" ").append(this.generator.formatDouble((double)PSGraphicsPainter.toPoints(p3y))).append(" curveto ");
        this.generator.writeln(sb.toString());
    }
}

