/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TextAreaTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static final Font Font = (Font)UIManager.get("Table.font");
    private static final Color ForegroundColor = (Color)UIManager.get("Table.foreground");
    private static final Color BackgroundColor = (Color)UIManager.get("Table.background");
    private static final Color SelectionForegroundColor = (Color)UIManager.get("Table.selectionForeground");
    private static final Color SelectionBackgroundColor = (Color)UIManager.get("Table.selectionBackground");
    private final JTextArea textArea = new JTextArea();
    private final JScrollPane scrollPane;
    private JTable table;

    public TextAreaTableCellEditor() {
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(Font);
        this.textArea.addKeyListener(this);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textArea.setText(value == null ? "" : value.toString());
        if (isSelected) {
            this.textArea.setForeground(SelectionForegroundColor);
            this.textArea.setBackground(SelectionBackgroundColor);
        } else {
            this.textArea.setForeground(ForegroundColor);
            this.textArea.setBackground(BackgroundColor);
        }
        return this.textArea;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.table == null) {
            this.table = table;
        }
        this.textArea.setText(value == null ? "" : value.toString());
        return this.scrollPane;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9 || e.getKeyCode() == 10 && e.isAltDown()) {
            int editingRow = this.table.getEditingRow();
            e.consume();
            this.fireEditingStopped();
            if (e.getKeyCode() == 9) {
                int nextEditingRow = editingRow + 1;
                if (nextEditingRow >= this.table.getRowCount()) {
                    nextEditingRow = 0;
                }
                this.table.getSelectionModel().setSelectionInterval(nextEditingRow, nextEditingRow);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

