/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.document;

import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DefaultDocumentFormatRegistryInstanceHolder;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.util.AssertUtils;

public final class DefaultDocumentFormatRegistry {
    public static final @NonNull DocumentFormat PDF = DefaultDocumentFormatRegistry.byExtension("pdf");
    public static final @NonNull DocumentFormat SWF = DefaultDocumentFormatRegistry.byExtension("swf");
    public static final @NonNull DocumentFormat HTML = DefaultDocumentFormatRegistry.byExtension("html");
    public static final @NonNull DocumentFormat XHTML = DefaultDocumentFormatRegistry.byExtension("xhtml");
    public static final @NonNull DocumentFormat ODT = DefaultDocumentFormatRegistry.byExtension("odt");
    public static final @NonNull DocumentFormat OTT = DefaultDocumentFormatRegistry.byExtension("ott");
    public static final @NonNull DocumentFormat FODT = DefaultDocumentFormatRegistry.byExtension("fodt");
    public static final @NonNull DocumentFormat SXW = DefaultDocumentFormatRegistry.byExtension("sxw");
    public static final @NonNull DocumentFormat DOC = DefaultDocumentFormatRegistry.byExtension("doc");
    public static final @NonNull DocumentFormat DOCX = DefaultDocumentFormatRegistry.byExtension("docx");
    public static final @NonNull DocumentFormat DOTX = DefaultDocumentFormatRegistry.byExtension("dotx");
    public static final @NonNull DocumentFormat RTF = DefaultDocumentFormatRegistry.byExtension("rtf");
    public static final @NonNull DocumentFormat WPD = DefaultDocumentFormatRegistry.byExtension("wpd");
    public static final @NonNull DocumentFormat TXT = DefaultDocumentFormatRegistry.byExtension("txt");
    public static final @NonNull DocumentFormat ODS = DefaultDocumentFormatRegistry.byExtension("ods");
    public static final @NonNull DocumentFormat OTS = DefaultDocumentFormatRegistry.byExtension("ots");
    public static final @NonNull DocumentFormat FODS = DefaultDocumentFormatRegistry.byExtension("fods");
    public static final @NonNull DocumentFormat SXC = DefaultDocumentFormatRegistry.byExtension("sxc");
    public static final @NonNull DocumentFormat XLS = DefaultDocumentFormatRegistry.byExtension("xls");
    public static final @NonNull DocumentFormat XLSX = DefaultDocumentFormatRegistry.byExtension("xlsx");
    public static final @NonNull DocumentFormat CSV = DefaultDocumentFormatRegistry.byExtension("csv");
    public static final @NonNull DocumentFormat TSV = DefaultDocumentFormatRegistry.byExtension("tsv");
    public static final @NonNull DocumentFormat ODP = DefaultDocumentFormatRegistry.byExtension("odp");
    public static final @NonNull DocumentFormat OTP = DefaultDocumentFormatRegistry.byExtension("otp");
    public static final @NonNull DocumentFormat FODP = DefaultDocumentFormatRegistry.byExtension("fodp");
    public static final @NonNull DocumentFormat SXI = DefaultDocumentFormatRegistry.byExtension("sxi");
    public static final @NonNull DocumentFormat PPT = DefaultDocumentFormatRegistry.byExtension("ppt");
    public static final @NonNull DocumentFormat PPTX = DefaultDocumentFormatRegistry.byExtension("pptx");
    public static final @NonNull DocumentFormat ODG = DefaultDocumentFormatRegistry.byExtension("odg");
    public static final @NonNull DocumentFormat OTG = DefaultDocumentFormatRegistry.byExtension("otg");
    public static final @NonNull DocumentFormat FODG = DefaultDocumentFormatRegistry.byExtension("fodg");
    public static final @NonNull DocumentFormat SVG = DefaultDocumentFormatRegistry.byExtension("svg");
    public static final @NonNull DocumentFormat VSD = DefaultDocumentFormatRegistry.byExtension("vsd");
    public static final @NonNull DocumentFormat VSDX = DefaultDocumentFormatRegistry.byExtension("vsdx");
    public static final @NonNull DocumentFormat PNG = DefaultDocumentFormatRegistry.byExtension("png");
    public static final @NonNull DocumentFormat JPEG = DefaultDocumentFormatRegistry.byExtension("jpg");
    public static final @NonNull DocumentFormat TIFF = DefaultDocumentFormatRegistry.byExtension("tif");
    public static final @NonNull DocumentFormat GIF = DefaultDocumentFormatRegistry.byExtension("gif");
    public static final @NonNull DocumentFormat BMP = DefaultDocumentFormatRegistry.byExtension("bmp");

    public static @NonNull DocumentFormatRegistry getInstance() {
        return DefaultDocumentFormatRegistryInstanceHolder.getInstance();
    }

    private static DocumentFormat byExtension(String extension) {
        DocumentFormat fmt = DefaultDocumentFormatRegistry.getInstance().getFormatByExtension(extension);
        AssertUtils.notNull(fmt, "byExtension(extension) must not be null");
        return fmt;
    }

    public static @Nullable DocumentFormat getFormatByExtension(@NonNull String extension) {
        return DefaultDocumentFormatRegistry.getInstance().getFormatByExtension(extension);
    }

    public static @Nullable DocumentFormat getFormatByMediaType(@NonNull String mediaType) {
        return DefaultDocumentFormatRegistry.getInstance().getFormatByMediaType(mediaType);
    }

    public static @NonNull Set<@NonNull DocumentFormat> getOutputFormats(@NonNull DocumentFamily family) {
        return DefaultDocumentFormatRegistry.getInstance().getOutputFormats(family);
    }

    private DefaultDocumentFormatRegistry() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

