/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.interfaces.Resettable;
import com.exlibris.core.infra.model.filetable.HFileTable;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.utils.FSUtil;
import com.exlibris.digitool.common.rule.xmlbeans.DeRuleDocument;
import com.exlibris.digitool.pi.profile.xmlbeans.PiProfile;
import com.exlibris.digitool.pi.profile.xmlbeans.PiProfileRuleDocument;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class ConfigurationProfileManager
implements Resettable {
    public static final String SYSTEM_DEFAULT_PROFILE = "default";
    private static ExLogger log = ExLogger.getExLogger(ConfigurationProfileManager.class);
    private static ConfigurationProfileManager pic;
    private static final String CONF_FILE_PREFIX = "com.exlibris.dps.repository";
    private static final String PI_PROFILE_RULES_FILE = "piprofilesrules";
    private static Map profilesHash;

    public static synchronized ConfigurationProfileManager getInstance() {
        if (pic == null) {
            pic = new ConfigurationProfileManager();
        }
        return pic;
    }

    private ConfigurationProfileManager() {
        this.load();
    }

    @Override
    public void reset() {
        this.load();
    }

    private void load() {
        try {
            FileTableManager manager = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
            List unitList = FSUtil.getUnitList();
            for (String uname : unitList) {
                HFileTable confFile = manager.getFileByKey("com.exlibris.dps.repository." + uname + "." + PI_PROFILE_RULES_FILE);
                if (confFile != null) {
                    PiProfileRuleDocument document = PiProfileRuleDocument.Factory.parse(confFile.getFile());
                    profilesHash.put(uname, document);
                    continue;
                }
                log.warn((Object)("Could not find profiles-rules configuration for unit '" + uname + "' will use system default"), new String[0]);
            }
            HFileTable confFile = manager.getFileByKey("com.exlibris.dps.repository.piprofilesrules");
            PiProfileRuleDocument document = PiProfileRuleDocument.Factory.parse(confFile.getFile());
            profilesHash.put(SYSTEM_DEFAULT_PROFILE, document);
        }
        catch (Exception e) {
            log.error("Failed to load profile - rule configuration from piprofilesrules" + e.getMessage() + e.getLocalizedMessage() + e.getCause(), new String[0]);
        }
    }

    public PiProfile[] getPiProfiles(String adminUnit) {
        PiProfile[] profd = null;
        PiProfileRuleDocument document = (PiProfileRuleDocument)profilesHash.get(adminUnit);
        if (document == null) {
            document = (PiProfileRuleDocument)profilesHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        if (document != null && document.getPiProfileRule() != null) {
            profd = document.getPiProfileRule().getPiProfileArray();
        }
        return profd;
    }

    public DeRuleDocument.DeRule[] getDeRules(String adminUnit) {
        DeRuleDocument.DeRule[] profd = null;
        PiProfileRuleDocument document = (PiProfileRuleDocument)profilesHash.get(adminUnit);
        if (document == null) {
            document = (PiProfileRuleDocument)profilesHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        if (document != null && document.getPiProfileRule() != null) {
            profd = document.getPiProfileRule().getDeRuleArray();
        }
        return profd;
    }

    public PiProfileRuleDocument getPiProfileRuleDocument(String adminUnit) {
        PiProfileRuleDocument document = (PiProfileRuleDocument)profilesHash.get(adminUnit);
        if (document == null) {
            document = (PiProfileRuleDocument)profilesHash.get(SYSTEM_DEFAULT_PROFILE);
        }
        return document;
    }

    static {
        profilesHash = new Hashtable();
    }
}

